/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.loottable.function;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.tslat.aoa3.common.registration.AoALootOperations;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.common.registration.custom.AoASkills;
import net.tslat.aoa3.player.skill.AoASkill;
import net.tslat.aoa3.util.PlayerUtil;

public class GrantSkillXp
extends LootItemConditionalFunction {
    private final AoASkill skill;
    private final float xp;

    protected GrantSkillXp(LootItemCondition[] lootConditions, AoASkill skill, float xp) {
        super(lootConditions);
        this.skill = skill;
        this.xp = xp;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)AoALootOperations.LootFunctions.GRANT_SKILL_XP.get();
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81458_);
        if (!(entity instanceof Player)) {
            entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        }
        if (entity instanceof ServerPlayer) {
            PlayerUtil.getAdventPlayer((ServerPlayer)entity).getSkill(this.skill).adjustXp(this.xp, false, false);
        }
        return stack;
    }

    public AoASkill getSkill() {
        return this.skill;
    }

    public float getXp() {
        return this.xp;
    }

    public static LootItemConditionalFunction.Builder<?> builder(AoASkill skill, float xp) {
        return GrantSkillXp.m_80683_(conditions -> new GrantSkillXp((LootItemCondition[])conditions, skill, xp));
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<GrantSkillXp> {
        public void serialize(JsonObject object, GrantSkillXp function, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)function, context);
            object.addProperty("skill", AoARegistries.AOA_SKILLS.getId(function.skill).toString());
            object.addProperty("xp", (Number)Float.valueOf(function.xp));
        }

        public GrantSkillXp deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootItemCondition[] conditions) {
            return new GrantSkillXp(conditions, AoASkills.getSkill(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"skill"))), GsonHelper.m_13915_((JsonObject)object, (String)"xp"));
        }
    }
}

