/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.sword;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.tslat.aoa3.common.registration.item.AoATiers;
import net.tslat.aoa3.content.item.LootModifyingItem;
import net.tslat.aoa3.content.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class EmberstoneSword
extends BaseSword
implements LootModifyingItem {
    public EmberstoneSword() {
        super(AoATiers.EMBERSTONE);
    }

    @Override
    public void doLootModification(List<ItemStack> existingLoot, LootContext lootContext) {
        if (!this.isEntityKillLoot(lootContext)) {
            return;
        }
        ServerLevel level = lootContext.m_78952_();
        Entity entity = (Entity)lootContext.m_165124_(LootContextParams.f_81455_);
        double posX = entity.m_20185_() + (double)(entity.m_20205_() / 2.0f);
        double posY = entity.m_20186_() + (double)(entity.m_20206_() / 2.0f);
        double posZ = entity.m_20189_() + (double)(entity.m_20205_() / 2.0f);
        for (int i = 0; i < existingLoot.size(); ++i) {
            ItemStack lootStack = existingLoot.get(i);
            Optional smeltRecipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{lootStack}), (Level)level);
            if (!smeltRecipe.isPresent()) continue;
            existingLoot.set(i, ((SmeltingRecipe)smeltRecipe.get()).m_8043_());
            for (int x = 0; x < 5; ++x) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, posX + (double)RandomUtil.randomValueUpTo(1.0f), posY + (double)RandomUtil.randomValueUpTo(1.0f), posZ + (double)RandomUtil.randomValueUpTo(1.0f), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new Component[0]));
    }
}

