/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.DischargeShotEntity;
import net.tslat.aoa3.content.item.weapon.shotgun.BaseShotgun;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;

public class DischargeShotgun
extends BaseShotgun {
    private int firingDelay;

    public DischargeShotgun(double dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(dmg, pellets, durability, fireDelayTicks, knockbackFactor, recoil);
        this.firingDelay = fireDelayTicks;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_SHOTGUN_HEAVY_FIRE_LONG.get();
    }

    @Override
    public Item getAmmoItem() {
        return (Item)AoAItems.DISCHARGE_CAPSULE.get();
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            bullet.doImpactEffect();
        }
        WorldUtil.createExplosion((Entity)shooter, bullet.f_19853_, (Entity)bullet, 2.5f);
    }

    @Override
    protected boolean fireGun(LivingEntity shooter, ItemStack stack, InteractionHand hand) {
        BaseBullet bullet = this.findAndConsumeAmmo(shooter, stack, hand);
        if (bullet == null) {
            return false;
        }
        int pellets = this.getPelletCount();
        float spreadFactor = 0.1f * (float)pellets * (1.0f - 0.15f * (float)EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.FORM.get()), (ItemStack)stack));
        for (int i = 0; i < pellets; ++i) {
            DischargeShotEntity pellet = new DischargeShotEntity(shooter, this, hand, 4, 1.0f, 0, RandomUtil.randomValueUpTo(0.5f) * spreadFactor, RandomUtil.randomValueUpTo(0.5f) * spreadFactor, RandomUtil.randomValueUpTo(0.5f) * spreadFactor);
            shooter.f_19853_.m_7967_((Entity)pellet);
        }
        if (!shooter.f_19853_.m_5776_()) {
            this.doFiringEffects(shooter, bullet, stack, hand);
        }
        return true;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.set(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.explosion", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

