/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.maul;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.content.capability.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;

public class BaseMaul
extends Item {
    private final Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> attributeModifiers;
    protected static final UUID KNOCKBACK_MODIFIER_UUID = UUID.fromString("f21dd55d-0e43-4e19-a683-1df45d51c60f");
    protected final float baseDamage;
    protected final double attackSpeed;
    protected final double knockback;

    public BaseMaul(float baseDmg, double attackSpeed, double knockback, int durability) {
        super(new Item.Properties().m_41503_(durability).m_41491_(AoACreativeModeTabs.MAULS));
        this.baseDamage = baseDmg;
        this.attackSpeed = attackSpeed;
        this.knockback = knockback;
        this.attributeModifiers = this.buildDefaultAttributes();
    }

    public float getAttackDamage() {
        return this.baseDamage;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public double getBaseKnockback() {
        return this.knockback;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    protected Lazy<ImmutableSetMultimap<Attribute, AttributeModifier>> buildDefaultAttributes() {
        return Lazy.of(() -> ImmutableSetMultimap.of((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION), (Object)Attributes.f_22282_, (Object)this.getKnockbackModifier(1.0f), (Object)((Attribute)ForgeMod.ATTACK_RANGE.get()), (Object)new AttributeModifier(UUID.fromString("93bb7485-ce86-4e78-ab50-26f53d78ad9d"), "AoAGreatbladeReach", 0.5, AttributeModifier.Operation.ADDITION)));
    }

    private AttributeModifier getKnockbackModifier(float attackStrengthMod) {
        return new AttributeModifier(KNOCKBACK_MODIFIER_UUID, "AoAMaulKnockback", this.getBaseKnockback() * (double)attackStrengthMod, AttributeModifier.Operation.ADDITION);
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity holder) {
        if (!world.f_46443_ && (double)state.m_60800_((BlockGetter)world, pos) != 0.0) {
            ItemUtil.damageItem(stack, holder, state.m_60767_() == Material.f_76278_ ? 1 : 2, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        float attackStr = player.m_36403_(0.0f);
        VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).setValue(attackStr);
        EntityUtil.reapplyAttributeModifier((LivingEntity)player, Attributes.f_22282_, this.getKnockbackModifier(attackStr), false);
        return false;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        float cooldown = VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).getValue();
        this.doMeleeEffect(stack, (Entity)target, attacker, cooldown);
        ItemUtil.damageItem(stack, attacker, InteractionHand.MAIN_HAND);
        EntityUtil.reapplyAttributeModifier(attacker, Attributes.f_22282_, this.getKnockbackModifier(1.0f), false);
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44982_ || enchantment == Enchantments.f_44980_ || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    protected void doMeleeEffect(ItemStack stack, Entity target, LivingEntity attacker, float attackCooldown) {
    }

    public int m_6473_() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new VolatileStackCapabilityProvider();
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            HashMultimap newMap = HashMultimap.create();
            ImmutableSetMultimap attributes = (ImmutableSetMultimap)this.attributeModifiers.get();
            for (Map.Entry entry : attributes.entries()) {
                newMap.put((Object)((Attribute)entry.getKey()), (Object)((AttributeModifier)entry.getValue()));
            }
            return newMap;
        }
        return super.getAttributeModifiers(slot, stack);
    }
}

