/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.gun;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.Tags;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.content.entity.projectile.gun.SeedDartEntity;
import net.tslat.aoa3.content.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;

public class Gardener
extends BaseGun {
    double dmg;
    int firingDelay;

    public Gardener(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(new Item.Properties().m_41491_(AoACreativeModeTabs.GUNS).m_41503_(durability).m_41497_(Rarity.RARE), dmg, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GUN_BLOWPIPE_SHOOT.get();
    }

    @Override
    public Item getAmmoItem() {
        return Items.f_42404_;
    }

    @Override
    @Nullable
    public BaseBullet findAndConsumeAmmo(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        if (shooter.m_6095_() != EntityType.f_20532_ || ItemUtil.findItemByTag((Player)shooter, (TagKey<Item>)Tags.Items.SEEDS, !shooter.f_19853_.m_5776_(), 1 + EnchantmentHelper.m_44843_((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return this.createProjectileEntity(shooter, gunStack, hand);
        }
        return null;
    }

    @Override
    public BaseBullet createProjectileEntity(LivingEntity shooter, ItemStack gunStack, InteractionHand hand) {
        return new SeedDartEntity(shooter, this, hand, 120, 0);
    }
}

