/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.weapon.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.content.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class BaseBow
extends BowItem {
    protected float drawSpeedMultiplier;
    protected double dmg;

    public BaseBow(double damage, float drawSpeedMultiplier, int durability) {
        super(new Item.Properties().m_41491_(AoACreativeModeTabs.BOWS).m_41503_(durability));
        this.dmg = damage;
        this.drawSpeedMultiplier = drawSpeedMultiplier;
    }

    public double getDamage() {
        return this.dmg;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack;
        boolean hasAmmo = !this.findAmmo(player, heldStack = player.m_21120_(hand), player.m_7500_()).m_41619_();
        InteractionResultHolder arrowNockEventResult = ForgeEventFactory.onArrowNock((ItemStack)heldStack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (arrowNockEventResult != null) {
            return arrowNockEventResult;
        }
        if (!player.m_7500_() && !hasAmmo) {
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)heldStack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity shooter, int timeLeft) {
        if (!(shooter instanceof Player)) {
            return;
        }
        Player pl = (Player)shooter;
        boolean infiniteAmmo = pl.m_7500_() || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        ItemStack ammoStack = this.findAmmo(pl, stack, infiniteAmmo);
        int charge = (int)((float)(this.m_8105_(stack) - timeLeft) * this.getDrawSpeedMultiplier());
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)world, (Player)pl, (int)charge, (!ammoStack.m_41619_() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (!ammoStack.m_41619_() || infiniteAmmo) {
            float velocity;
            if (ammoStack.m_41619_()) {
                ammoStack = new ItemStack((ItemLike)Items.f_42412_);
            }
            if ((double)(velocity = BaseBow.m_40661_((int)charge)) >= 0.1) {
                if (!world.f_46443_) {
                    CustomArrowEntity arrow = this.makeArrow((LivingEntity)pl, stack, ammoStack, velocity, !infiniteAmmo);
                    arrow = this.doArrowMods(arrow, shooter, ammoStack, timeLeft);
                    world.m_7967_((Entity)arrow);
                }
                world.m_6263_(null, pl.m_20185_(), pl.m_20186_(), pl.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (float)RandomUtil.randomValueBetween(1.2f, 1.6f) + velocity * 0.5f);
                if (!infiniteAmmo && !pl.m_150110_().f_35937_) {
                    ammoStack.m_41774_(1);
                    if (ammoStack.m_41619_()) {
                        pl.m_150109_().m_36057_(ammoStack);
                    }
                }
                pl.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    protected ItemStack findAmmo(Player shooter, ItemStack bowStack, boolean infiniteAmmo) {
        return shooter.m_6298_(bowStack);
    }

    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.m_41720_() instanceof ArrowItem ? ammoStack.m_41720_() : Items.f_42412_);
        CustomArrowEntity arrow = CustomArrowEntity.fromArrow(arrowItem.m_6394_(shooter.f_19853_, ammoStack, shooter), this, shooter, this.getDamage());
        arrow.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity * 3.0f, 1.0f);
        if (velocity == 1.0f) {
            arrow.m_36762_(true);
        }
        int powerEnchant = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
        int punchEnchant = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
        if (powerEnchant > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerEnchant * 1.5 + 1.0);
        }
        if (punchEnchant > 0) {
            arrow.m_36735_(punchEnchant);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack) > 0) {
            arrow.m_20254_(100);
        }
        bowStack.m_41622_(1, shooter, firingEntity -> firingEntity.m_21190_(shooter.m_7655_()));
        if (!consumeAmmo || shooter instanceof Player && ((Player)shooter).m_7500_() && (ammoStack.m_41720_() == Items.f_42737_ || ammoStack.m_41720_() == Items.f_42738_)) {
            arrow.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        return arrow;
    }

    public float getDrawSpeedMultiplier() {
        return this.drawSpeedMultiplier;
    }

    public CustomArrowEntity doArrowMods(CustomArrowEntity arrow, LivingEntity shooter, ItemStack ammoStack, int useTicksRemaining) {
        return arrow;
    }

    public void onEntityHit(CustomArrowEntity arrow, Entity target, Entity shooter, double damage, float drawStrength) {
    }

    public void onBlockHit(CustomArrowEntity arrow, BlockHitResult rayTrace, Entity shooter) {
    }

    public void onArrowTick(CustomArrowEntity arrow, Entity shooter) {
    }

    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * 0.5 * (double)(drawStrength / 3.0f);
        if (isCritical) {
            damage += damage + damage * RandomUtil.randomScaledGaussianValue(0.35f);
        }
        return damage;
    }

    public int m_6473_() {
        return 8;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, new Component[]{Component.m_237113_((String)Double.toString(this.getDamage()))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.bow.drawSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, new Component[]{Component.m_237113_((String)Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier()) / 720) / 100.0))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new Component[]{LocaleUtil.getLocaleMessage(Items.f_42412_.m_5524_())}));
    }
}

