/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.tablet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.common.registration.AoACreativeModeTabs;
import net.tslat.aoa3.content.entity.tablet.SoulTabletEntity;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PlayerUtil;

public abstract class TabletItem
extends Item {
    private final float initialSoulCost;
    private final float perTickSoulCost;
    private final int animaLevelReq;
    private final int effectRadius;

    public TabletItem(float placementCost, float tickSoulDrain, int levelReq, int effectRadius) {
        super(new Item.Properties().m_41491_(AoACreativeModeTabs.TABLETS).m_41487_(1));
        this.initialSoulCost = placementCost;
        this.perTickSoulCost = tickSoulDrain;
        this.animaLevelReq = levelReq;
        this.effectRadius = effectRadius;
    }

    public final float getSoulDrain() {
        return this.perTickSoulCost;
    }

    public int getEffectRadius() {
        return this.effectRadius;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        BlockState targetBlockState = context.m_43725_().m_8055_(pos);
        if (context.m_43719_() != Direction.UP || !targetBlockState.m_60783_((BlockGetter)world, pos, Direction.UP)) {
            return InteractionResult.FAIL;
        }
        if (context.m_43723_() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)context.m_43723_();
            ServerPlayerDataManager serverPlayerDataManager = PlayerUtil.getAdventPlayer(player);
        }
        return InteractionResult.PASS;
    }

    protected abstract SoulTabletEntity getTabletEntity(Level var1, ServerPlayer var2);

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tablet.usageCost", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[]{Component.m_237113_((String)String.valueOf((float)((int)(this.perTickSoulCost * 2000.0f)) / 100.0f))}));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.tablet.radius", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new Component[]{Component.m_237113_((String)String.valueOf(this.effectRadius))}));
    }
}

