/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.item.armour;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.tslat.aoa3.content.item.armour.AdventArmour;
import net.tslat.aoa3.player.ServerPlayerDataManager;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GhoulishArmour
extends AdventArmour {
    public GhoulishArmour(EquipmentSlot slot) {
        super(ItemUtil.customArmourMaterial("aoa3:ghoulish", 61, new int[]{6, 6, 8, 6}, 10, SoundEvents.f_11675_, 7.0f), slot);
    }

    @Override
    public AdventArmour.Type setType() {
        return AdventArmour.Type.GHOULISH;
    }

    @Override
    public void onDamageDealt(ServerPlayerDataManager plData, @Nullable HashSet<EquipmentSlot> slots, LivingHurtEvent event) {
        if (slots != null && DamageUtil.isBlasterDamage(event.getSource())) {
            event.setAmount(event.getAmount() * (1.0f + (float)slots.size() * 0.1f));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)this.pieceEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.ghoulish_armour.desc.1", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
        tooltip.add((Component)this.setEffectHeader());
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("item.aoa3.ghoulish_armour.desc.2", LocaleUtil.ItemDescriptionType.BENEFICIAL, new Component[0]));
    }
}

