/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobEffects;
import net.tslat.aoa3.content.entity.ai.mob.TelegraphedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.mobeffect.BleedingEffect;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import software.bernie.geckolib3.core.manager.AnimationData;

public class WoodGiantEntity
extends AoAMeleeMob {
    public static final EntityDataAccessor<Integer> STAGE = SynchedEntityData.m_135353_(WoodGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AttributeModifier STAGE_ARMOUR_MOD = new AttributeModifier(UUID.fromString("076a790a-a765-4313-b517-527b758e839f"), "StageArmourModifier", 1.0, AttributeModifier.Operation.ADDITION){

        public double m_22218_() {
            return 35 - Math.max(0, WoodGiantEntity.this.getStage()) * 10;
        }
    };
    private final AttributeModifier STAGE_TOUGHNESS_MOD = new AttributeModifier(UUID.fromString("3977cd08-2bbe-48ed-b66e-557ada8565b9"), "StageToughnessModifier", 1.0, AttributeModifier.Operation.ADDITION){

        public double m_22218_() {
            return 50 - Math.max(0, WoodGiantEntity.this.getStage()) * 15;
        }
    };
    private int lastMeleeHit = 0;

    public WoodGiantEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new TelegraphedMeleeAttackGoal<WoodGiantEntity>(this).preAttackTime(this.getPreAttackTime()).attackInterval(this.m_21304_()));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(STAGE, (Object)0);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22284_, this.STAGE_ARMOUR_MOD, false);
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22285_, this.STAGE_TOUGHNESS_MOD, false);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.875f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.TREE_FALL.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.WOODY_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.WOODY_THUMP.get();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            if (!this.f_19853_.m_5776_() && DamageUtil.isMeleeDamage(source)) {
                this.lastMeleeHit = this.f_19797_;
                Entity entity = source.m_7639_();
                if (entity instanceof LivingEntity) {
                    LivingEntity attacker = (LivingEntity)entity;
                    ServerParticlePacket particlePacket = new ServerParticlePacket();
                    ItemStack weapon = attacker.m_21120_(InteractionHand.MAIN_HAND);
                    if (weapon.m_41735_(Blocks.f_49999_.m_49966_())) {
                        this.lastMeleeHit += 100;
                        particlePacket.particle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this, true, 0.0, 0.0, 0.0, 1, 5);
                    }
                    if (this.getStage() < 3) {
                        this.setStage(this.getStage() + 1);
                        particlePacket.particle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this, true, 0.0, 0.0, 0.0, 1, 3);
                        BleedingEffect.apply(attacker, new EffectBuilder((MobEffect)AoAMobEffects.BLEEDING.get(), 600).hideParticles().build(), (Entity)this);
                        this.m_216990_((SoundEvent)AoASounds.HEAVY_WOOD_SHATTER.get());
                    }
                    AoAPackets.messageNearbyPlayers(particlePacket, (ServerLevel)this.f_19853_, this.m_20182_(), 20.0);
                }
            }
            return true;
        }
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WoodStage")) {
            this.setStage(compound.m_128451_("WoodStage"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("WoodStage", ((Integer)this.m_20088_().m_135370_(STAGE)).intValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ - this.lastMeleeHit > 600) {
            int stage = this.getStage();
            this.lastMeleeHit = this.f_19797_;
            if (stage > 0 && stage <= 3) {
                this.setStage(stage - 1);
                this.m_5634_(20.0f);
            }
        }
    }

    private void setStage(int stage) {
        int oldStage = this.getStage();
        int clampedStage = Mth.m_14045_((int)stage, (int)0, (int)3);
        this.m_20088_().m_135381_(STAGE, (Object)clampedStage);
        EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22284_, this.STAGE_ARMOUR_MOD, false);
        EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22285_, this.STAGE_TOUGHNESS_MOD, false);
        if (oldStage < stage) {
            ServerParticlePacket packet = new ServerParticlePacket();
            for (int i = 0; i < 10; ++i) {
                packet.particle((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49999_.m_49966_()), (Entity)this, true);
            }
            AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.f_19853_, this.m_20182_(), 20.0);
        }
    }

    private int getStage() {
        return (Integer)this.m_20088_().m_135370_(STAGE);
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_SLAM));
    }
}

