/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import java.util.EnumSet;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.ServerParticlePacket;
import net.tslat.aoa3.common.particletype.CustomisableParticleType;
import net.tslat.aoa3.common.registration.AoAParticleTypes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.ai.ExtendedGoal;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.misc.SandGiantPitTrapEntity;
import net.tslat.aoa3.content.entity.misc.SandGiantSpikeTrapEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.RandomUtil;
import software.bernie.geckolib3.core.manager.AnimationData;

public class SandGiantEntity
extends AoAMeleeMob {
    public SandGiantEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 1.5f;
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new TrapChaseGoal<SandGiantEntity>(this, pos -> RandomUtil.fiftyFifty() ? new SandGiantPitTrapEntity(this.f_19853_, (Vec3)pos) : new SandGiantSpikeTrapEntity(this.f_19853_, (Vec3)pos)).attackEvenIfMidair().spawnExtraTrapsOnStart(20).spawnFrequency(10).maxRuntime((IntProvider)UniformInt.m_146622_((int)160, (int)240)).cooldown((IntProvider)UniformInt.m_146622_((int)300, (int)500)).chargeUpTime(15).onStart(goal -> this.setAttackState(1)).onStop(goal -> this.setAttackState(0)));
        this.f_21345_.m_25352_(3, new ExtendedMeleeAttackGoal<SandGiantEntity>(this).attackInterval((IntProvider)ConstantInt.m_146483_((int)this.m_21304_())).actionTelegraphTicks(this.getPreAttackTime()).maxRuntime((IntProvider)UniformInt.m_146622_((int)500, (int)700)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.9375f;
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.DENSE_SAND_POUR.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.SANDY_HIT.get();
    }

    @Override
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.SANDY_THUD.get();
    }

    public boolean m_6094_() {
        return false;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_SLAM));
        animationData.addAnimationController(AoAAnimations.genericHeldPoseController(this, AoAAnimations.ATTACK_CHARGE, AoAAnimations.ATTACK_CHARGE_END, entity -> entity.getAttackState() == 1));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.f_19797_ % 30 == 0 && this.getAttackState() == 0 && EntityUtil.getCurrentHealthPercent((LivingEntity)this) < 0.5f) {
            this.spawnTrap();
        }
    }

    private void spawnTrap() {
        if (this.m_5448_() == null) {
            return;
        }
        BlockPos.MutableBlockPos pos = this.m_5448_().m_20183_().m_122032_();
        BlockState block = this.f_19853_.m_8055_((BlockPos)pos);
        if (block.m_60795_()) {
            int x = 10;
            while (x-- >= 0 && pos.m_123342_() > this.f_19853_.m_141937_() && (block = this.f_19853_.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN))).m_60795_()) {
            }
            if (block.m_60795_()) {
                return;
            }
            this.f_19853_.m_7967_((Entity)(RandomUtil.fiftyFifty() ? new SandGiantPitTrapEntity(this.f_19853_, Vec3.m_82539_((Vec3i)pos.m_122173_(Direction.UP))) : new SandGiantSpikeTrapEntity(this.f_19853_, Vec3.m_82539_((Vec3i)pos.m_122173_(Direction.UP)))));
        }
    }

    private static class TrapChaseGoal<T extends Mob>
    extends ExtendedGoal<T> {
        private final Function<Vec3, Entity> trapFactory;
        protected int trapSpawnFrequency = 20;
        protected int initialTrapSpawns = 0;
        protected boolean onlyIfOnGround = true;
        private int nextSpawnTime = 0;

        TrapChaseGoal(T entity, Function<Vec3, Entity> trapFactory) {
            super(entity);
            this.trapFactory = trapFactory;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public TrapChaseGoal<T> spawnFrequency(int ticks) {
            this.trapSpawnFrequency = ticks;
            return this;
        }

        public TrapChaseGoal<T> spawnExtraTrapsOnStart(int amount) {
            this.initialTrapSpawns = amount;
            return this;
        }

        public TrapChaseGoal<T> attackEvenIfMidair() {
            this.onlyIfOnGround = false;
            return this;
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (this.entity.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
                return false;
            }
            LivingEntity target = this.entity.m_5448_();
            return EntityPredicate.TARGETABLE_ENTITIES.test((Entity)target);
        }

        @Override
        public boolean m_8045_() {
            if (!super.m_8045_()) {
                return false;
            }
            return EntityPredicate.TARGETABLE_ENTITIES.test((Entity)this.entity.m_5448_());
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.entity.m_21573_().m_26573_();
            this.entity.m_21561_(true);
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            this.entity.m_21561_(false);
        }

        @Override
        public void m_8037_() {
            block10: {
                block8: {
                    LivingEntity target;
                    block9: {
                        super.m_8037_();
                        if (!this.hasChargedUp()) break block8;
                        target = this.entity.m_5448_();
                        ServerParticlePacket packet = new ServerParticlePacket();
                        double centerX = this.entity.m_20182_().m_7096_();
                        double centerZ = this.entity.m_20182_().m_7094_();
                        for (double angle = 0.0; angle < Math.PI * 2; angle += 0.06981317007977318) {
                            packet.particle((ParticleOptions)new CustomisableParticleType.Data((ParticleType<CustomisableParticleType.Data>)((ParticleType)AoAParticleTypes.SANDSTORM.get()), 0.5f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.entity.m_19879_()), centerX + 4.0 * Math.cos(angle), this.entity.m_20182_().m_7098_(), centerZ + 4.0 * Math.sin(angle), 0.0, 0.25, 0.0, 1);
                        }
                        AoAPackets.messageNearbyPlayers(packet, (ServerLevel)this.entity.f_19853_, this.entity.m_20182_(), 20.0);
                        if (this.entity.f_19797_ % 20 == 0 && (this.taskExpiresAt == Integer.MAX_VALUE || this.runningTime + 20 < this.taskExpiresAt)) {
                            this.entity.m_5496_((SoundEvent)AoASounds.SAND_WIND.get(), 1.0f, 0.5f);
                        }
                        if (!this.onlyIfOnGround && !target.m_20096_()) {
                            this.resetActionTelegraph();
                            return;
                        }
                        if (this.entity.f_19797_ < this.nextSpawnTime) {
                            return;
                        }
                        if (this.isTelegraphingAction()) break block9;
                        this.startTelegraphingNextAction();
                        break block10;
                    }
                    if (!this.hasActionTelegraphFinished()) break block10;
                    Entity trap = this.trapFactory.apply(target.m_20182_());
                    if (trap != null) {
                        this.entity.f_19853_.m_7967_(trap);
                    }
                    this.nextSpawnTime = this.entity.f_19797_ + this.trapSpawnFrequency;
                    this.startTelegraphingNextAction();
                    break block10;
                }
                if (this.chargeUpTime - 1 == this.runningTime) {
                    for (int i = 0; i < this.initialTrapSpawns; ++i) {
                        Entity trap;
                        BlockPos.MutableBlockPos pos = RandomPos.m_217851_((RandomSource)RandomUtil.RANDOM, (int)5, (int)5).m_121955_((Vec3i)this.entity.m_5448_().m_20183_()).m_122032_();
                        BlockState block = this.entity.f_19853_.m_8055_((BlockPos)pos);
                        if (!block.m_60795_()) continue;
                        int x = 10;
                        while (x-- >= 0 && pos.m_123342_() > this.entity.f_19853_.m_141937_() && (block = this.entity.f_19853_.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN))).m_60795_()) {
                        }
                        if (block.m_60795_() || (trap = this.trapFactory.apply(Vec3.m_82539_((Vec3i)pos.m_122173_(Direction.UP)))) == null) continue;
                        this.entity.f_19853_.m_7967_(trap);
                    }
                }
            }
        }
    }
}

