/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.overworld;

import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedFindNearbyTargetGoal;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedHurtByTargetGoal;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import net.tslat.aoa3.content.entity.mob.overworld.ChargerEntity;
import net.tslat.aoa3.library.builder.EntityPredicate;
import net.tslat.aoa3.util.EntitySpawningUtil;
import net.tslat.aoa3.util.RandomUtil;
import software.bernie.geckolib3.core.manager.AnimationData;

public class KingChargerEntity
extends AoAMeleeMob {
    private int nextChargerSpawn = 0;

    public KingChargerEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new ExtendedMeleeAttackGoal<KingChargerEntity>(this).speedModifier(1.125).attackInterval((IntProvider)ConstantInt.m_146483_((int)this.m_21304_())).actionTelegraphTicks(this.getPreAttackTime()).onStart(goal -> this.m_6858_(true)).onStop(goal -> this.m_6858_(false)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, new ExtendedHurtByTargetGoal<KingChargerEntity>(this).alertNearbyEntities(40, entity -> entity instanceof ChargerEntity));
        this.f_21346_.m_25352_(2, new ExtendedFindNearbyTargetGoal<KingChargerEntity>(this, true, EntityPredicate.SURVIVAL_PLAYER).searchRadius(10.0));
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.84375f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_DEATH.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CHARGER_HURT.get();
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.nextChargerSpawn < this.f_19797_) {
            ChargerEntity charger;
            LivingEntity target = this.m_5448_();
            if (target != null && (charger = (ChargerEntity)((Object)EntitySpawningUtil.spawnEntity((ServerLevel)this.f_19853_, (EntityType)AoAMobs.CHARGER.get(), (Vec3i)RandomUtil.getRandomPositionWithinRange(target.m_20183_(), 40, 10, 40, 30, 0, 30, true, this.f_19853_, 2, state -> true), MobSpawnType.MOB_SUMMONED))) != null) {
                charger.m_6710_(target);
            }
            this.nextChargerSpawn = this.f_19797_ + RandomUtil.randomNumberBetween(80, 140);
        }
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericWalkRunIdleController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_BITE));
    }
}

