/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.lelyetia;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.ColourUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.WorldUtil;
import software.bernie.geckolib3.core.manager.AnimationData;

public class FlyeEntity
extends AoAFlyingMeleeMob {
    private static final EntityDataAccessor<BlockPos> ALTAR_POS = SynchedEntityData.m_135353_(FlyeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private BlockPos altarPos = null;

    public FlyeEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
    }

    public FlyeEntity(Level world, BlockPos altarPos) {
        this((EntityType<? extends FlyingMob>)((EntityType)AoAMobs.FLYE.get()), world);
        BlockPos spawnPos;
        this.f_19804_.m_135381_(ALTAR_POS, (Object)altarPos);
        while (world.m_8055_(spawnPos = RandomUtil.getRandomPositionWithinRange(altarPos, 20, 20, 20)).m_60767_().m_76334_()) {
        }
        this.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
        EntityUtil.applyPotions((Entity)this, new EffectBuilder(MobEffects.f_19619_, 9999999).isAmbient().hideParticles());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ALTAR_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_FLYE_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_FLYE_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_FLYE_HURT.get();
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(ALTAR_POS)) {
            this.altarPos = (BlockPos)this.f_19804_.m_135370_(ALTAR_POS);
            if (this.altarPos == BlockPos.f_121853_) {
                this.altarPos = null;
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.altarPos != null) {
            compound.m_128356_("GrawAltarPos", this.altarPos.m_121878_());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("GrawAltarPos")) {
            this.altarPos = BlockPos.m_122022_((long)compound.m_128454_("GrawAltarPos"));
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.altarPos != null && this.f_19853_.m_46467_() % 40L == 0L && !this.altarPos.m_123314_((Vec3i)this.m_20183_(), 30.0)) {
            double posX = ((float)this.altarPos.m_123341_() + this.f_19796_.m_188501_() * 2.0f - 1.0f) * 10.0f;
            double posY = ((float)this.altarPos.m_123342_() + this.f_19796_.m_188501_() * 2.0f - 1.0f) * 10.0f;
            double posZ = ((float)this.altarPos.m_123343_() + this.f_19796_.m_188501_() * 2.0f - 1.0f) * 10.0f;
            this.m_21566_().m_6849_(posX, posY, posZ, 1.0);
        }
    }

    public int m_19876_() {
        if (this.getGrawAltarPos() != null) {
            return ColourUtil.GREEN;
        }
        return super.m_19876_();
    }

    @Nullable
    public BlockPos getGrawAltarPos() {
        return this.altarPos;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.f_19853_.f_46443_) {
            Player pl;
            Entity entity;
            if (WorldUtil.isWorld(this.f_19853_, AoADimensions.LELYETIA.key) && DamageUtil.isMeleeDamage(cause) && (entity = cause.m_7639_()) instanceof Player && (pl = (Player)entity).m_20186_() >= 120.0 && ItemUtil.findInventoryItem(pl, new ItemStack((ItemLike)AoAItems.BLANK_REALMSTONE.get()), true, 1)) {
                ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((ItemLike)AoAItems.HAVEN_REALMSTONE.get()));
            }
            if (this.altarPos != null && this.f_20889_ > 0) {
                this.m_5552_(new ItemStack((ItemLike)AoAItems.GUARDIANS_EYE.get()), 0.0f);
            }
        }
    }

    @Override
    protected int getPreAttackTime() {
        return 7;
    }

    @Override
    protected int getAttackSwingDuration() {
        return 14;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericFlyController(this));
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_STRIKE));
    }
}

