/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.deeplands;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.content.entity.base.AoAMeleeMob;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;

public class CaveCreepEntity
extends AoAMeleeMob {
    private static final AnimationBuilder LIFT_HOLD_ANIM = new AnimationBuilder().addAnimation("misc.lift.hold", Boolean.valueOf(true));
    private static final AnimationBuilder LIFT_ANIM = new AnimationBuilder().addAnimation("misc.lift").addAnimation("misc.lift.hold", Boolean.valueOf(true));
    private static final AnimationBuilder DROP_ANIM = new AnimationBuilder().addAnimation("misc.drop");
    private static final AnimationBuilder TRANSITION_WALK_ANIM = new AnimationBuilder().addAnimation("move.walk.transition", Boolean.valueOf(true));
    private static final AnimationBuilder LIFTED_WALK_ANIM = new AnimationBuilder().addAnimation("move.walk.lifted", Boolean.valueOf(true));
    private static final EntityDataAccessor<Integer> LAST_AGGRO_TIME = SynchedEntityData.m_135353_(CaveCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_AGGRO = SynchedEntityData.m_135353_(CaveCreepEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastAggroChange = -1;
    private boolean isAggro = false;

    public CaveCreepEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 1.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(LAST_AGGRO_TIME, (Object)-1);
        this.m_20088_().m_135372_(IS_AGGRO, (Object)false);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_CAVE_CREEP_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_CAVE_CREEP_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_CAVE_CREEP_HURT.get();
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public void m_6710_(@Nullable LivingEntity target) {
        LivingEntity oldTarget = this.m_5448_();
        super.m_6710_(target);
        if (target != oldTarget) {
            this.lastAggroChange = this.f_19797_;
            this.m_20088_().m_135381_(LAST_AGGRO_TIME, (Object)this.lastAggroChange);
            this.m_20088_().m_135381_(IS_AGGRO, (Object)(this.m_5448_() != null ? 1 : 0));
        }
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(LAST_AGGRO_TIME)) {
            this.lastAggroChange = (Integer)this.m_20088_().m_135370_(LAST_AGGRO_TIME);
        } else if (key.equals(IS_AGGRO)) {
            this.isAggro = (Boolean)this.m_20088_().m_135370_(IS_AGGRO);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lastAggroChange >= 0 && this.f_19797_ - this.lastAggroChange > 10) {
            this.lastAggroChange = -1;
        }
    }

    @Override
    protected int getAttackSwingDuration() {
        return 11;
    }

    @Override
    protected int getPreAttackTime() {
        return 6;
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(AoAAnimations.genericAttackController(this, AoAAnimations.ATTACK_BITE));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "movement", 0.0f, event -> {
            if (event.isMoving()) {
                if (this.lastAggroChange >= 0) {
                    event.getController().setAnimation(TRANSITION_WALK_ANIM);
                } else if (this.isAggro) {
                    event.getController().setAnimation(LIFTED_WALK_ANIM);
                } else {
                    event.getController().setAnimation(AoAAnimations.WALK);
                }
                return PlayState.CONTINUE;
            }
            if (this.isAggro) {
                if (this.lastAggroChange == -1) {
                    event.getController().setAnimation(LIFT_HOLD_ANIM);
                }
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "lifts", 0.0f, event -> {
            if (this.lastAggroChange >= 0) {
                if (this.isAggro) {
                    event.getController().setAnimation(LIFT_ANIM);
                } else {
                    event.getController().setAnimation(DROP_ANIM);
                }
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
    }
}

