/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.mob.abyss;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.common.registration.AoAAttributes;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.content.entity.base.AoARangedMob;
import net.tslat.aoa3.content.entity.projectile.mob.BaseMobProjectile;
import net.tslat.aoa3.content.entity.projectile.mob.MagicBallEntity;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class WebReaperEntity
extends AoARangedMob {
    private static final EntityDataAccessor<Integer> STAGE = SynchedEntityData.m_135353_(WebReaperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AttributeModifier STAGE_HEALTH_MOD = new AttributeModifier(UUID.fromString("9c59eceb-dcd0-40e0-a608-a46d3794b1c3"), "StageHealthModifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

        public double m_22218_() {
            return Math.max(0.0f, WebReaperEntity.this.stageMod - 1.0f);
        }
    };
    private final AttributeModifier STAGE_KNOCKBACK_MOD = new AttributeModifier(UUID.fromString("a7cd0b89-ca94-4e54-a0c4-f56e8cb70bb0"), "StageKnockbackModifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

        public double m_22218_() {
            return Math.max(0.0, (double)(WebReaperEntity.this.stageMod - 1.0f) * 0.83);
        }
    };
    private final AttributeModifier STAGE_DAMAGE_MOD = new AttributeModifier(UUID.fromString("104c09f0-28cc-43dd-81c0-10de6b3083bd"), "StageDamageModifier", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL){

        public double m_22218_() {
            return Math.max(0.0f, WebReaperEntity.this.stageMod - 1.0f);
        }
    };
    private int stage;
    private float stageMod;
    private boolean shouldHeal = false;

    public WebReaperEntity(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22276_, this.STAGE_HEALTH_MOD, false);
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22278_, this.STAGE_KNOCKBACK_MOD, false);
        EntityUtil.applyAttributeModifierSafely((LivingEntity)this, (Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get(), this.STAGE_DAMAGE_MOD, false);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.stage = 1;
        this.stageMod = 1.0f;
        this.f_19804_.m_135372_(STAGE, (Object)1);
    }

    @Override
    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 2.375f * this.stageMod;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return (SoundEvent)AoASounds.ENTITY_WEB_REAPER_SHOOT.get();
    }

    public int getStage() {
        return this.stage;
    }

    public float getStageMod() {
        return this.stageMod;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (heldStack.m_41720_() == AoAItems.NIGHTMARE_FLAKES.get()) {
            if (this.stage >= 10) {
                return InteractionResult.FAIL;
            }
            if (!this.f_19853_.f_46443_) {
                heldStack.m_41774_(1);
                ++this.stage;
                this.updateStage();
                this.shouldHeal = true;
            }
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_41720_() == Items.f_42690_ && this.stage > 1) {
            if (!this.f_19853_.f_46443_) {
                player.m_21008_(hand, new ItemStack((ItemLike)AoAItems.BOOK_OF_SHADOWS.get()));
                if (this.stage <= 10) {
                    this.stage += 5;
                    this.updateStage();
                    this.shouldHeal = true;
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void updateStage() {
        if (!this.f_19853_.f_46443_) {
            this.f_19804_.m_135381_(STAGE, (Object)this.stage);
        } else {
            this.stage = (Integer)this.f_19804_.m_135370_(STAGE);
        }
        this.stageMod = 1.0f + (float)(this.stage - 1) / 7.5f;
        if (!this.f_19853_.f_46443_) {
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22276_, this.STAGE_HEALTH_MOD, false);
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, Attributes.f_22278_, this.STAGE_KNOCKBACK_MOD, false);
            EntityUtil.reapplyAttributeModifier((LivingEntity)this, (Attribute)AoAAttributes.RANGED_ATTACK_DAMAGE.get(), this.STAGE_DAMAGE_MOD, false);
        }
        this.m_6210_();
        this.f_21364_ = (int)this.m_21233_() / 10 + (int)(((double)this.m_21233_() - this.m_21133_(Attributes.f_22276_)) * (double)0.1f);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.m_6095_().m_20680_().m_20388_(this.stageMod);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        if (key.equals(STAGE)) {
            this.updateStage();
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("WebReaperStage")) {
            this.stage = compound.m_128451_("WebReaperStage");
            this.updateStage();
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.stage > 1) {
            compound.m_128405_("WebReaperStage", this.stage);
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new MagicBallEntity(this, BaseMobProjectile.Type.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (this.stage >= 15) {
            EntityUtil.applyPotions(target, new EffectBuilder(MobEffects.f_19615_, 100).level(2));
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (cause.m_7639_() instanceof ServerPlayer && this.stage >= 15) {
            AdvancementUtil.completeAdvancement((ServerPlayer)cause.m_7639_(), new ResourceLocation("aoa3", "abyss/reaper_reaper"), "nightmare_web_reaper_kill");
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.shouldHeal) {
            this.m_21153_(this.m_21233_());
            this.shouldHeal = false;
        }
    }

    public Component m_7755_() {
        String stagePrefix;
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        String baseName = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_()).m_135815_();
        String string = this.stage >= 15 ? "nightmare" : (stagePrefix = this.stage >= 5 ? "empowered" : null);
        if (stagePrefix != null) {
            return LocaleUtil.getLocaleMessage("entity.aoa3." + stagePrefix + "_" + baseName);
        }
        return LocaleUtil.getLocaleMessage("entity.aoa3." + baseName);
    }
}

