/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.client.render.AoAAnimations;
import net.tslat.aoa3.common.misc.AoAAnimationController;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.entity.AoABrainMemories;
import net.tslat.aoa3.content.entity.boss.AoABoss;
import net.tslat.aoa3.content.entity.brain.task.custom.ChargeAttack;
import net.tslat.aoa3.content.entity.brain.task.custom.FleeTarget;
import net.tslat.aoa3.content.entity.brain.task.custom.GroundSlamAttack;
import net.tslat.aoa3.content.entity.brain.task.custom.WalkOrRunToWalkTarget;
import net.tslat.aoa3.library.builder.EffectBuilder;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.CustomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.ReactToUnreachableTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.manager.AnimationData;

public class SmashEntity
extends AoABoss {
    protected static final EntityDataAccessor<Boolean> ENRAGED = SynchedEntityData.m_135353_(SmashEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier ENRAGED_DAMAGE_MOD = new AttributeModifier(UUID.fromString("104c09f0-28cc-43dd-81c0-10de6b3083bd"), "EnragedDamageModifier", (double)1.2f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ENRAGED_ARMOUR_MOD = new AttributeModifier(UUID.fromString("bbbdf964-689b-4bcf-9a23-122a7bba682e"), "EnragedArmourModifier", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ENRAGED_TOUGHNESS_MOD = new AttributeModifier(UUID.fromString("ac843c67-4731-4e77-85e9-6992bd92ae4b"), "EnragedToughnessModifier", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final int AXE_SWING_STATE = 0;
    private static final int AXE_SLAM_STATE = 1;
    private static final int CHARGE_STATE = 2;
    private static final AnimationBuilder WALK_BOTTOM_HALF = new AnimationBuilder().addAnimation("move.walk.bottom_half", Boolean.valueOf(true));
    private static final AnimationBuilder WALK_TOP_HALF = new AnimationBuilder().addAnimation("move.walk.top_half", Boolean.valueOf(true));
    private static final AnimationBuilder RUN_BOTTOM_HALF = new AnimationBuilder().addAnimation("move.run.bottom_half", Boolean.valueOf(true));
    private static final AnimationBuilder RUN_TOP_HALF = new AnimationBuilder().addAnimation("move.run.top_half", Boolean.valueOf(true));
    private static final AnimationBuilder ENRAGE = new AnimationBuilder().addAnimation("misc.enrage", Boolean.valueOf(false));
    private static final AnimationBuilder ENRAGED_IDLE = new AnimationBuilder().addAnimation("misc.idle.enraged", Boolean.valueOf(true));
    private static final AnimationBuilder CHARGE_UP = new AnimationBuilder().addAnimation("misc.charge_up", Boolean.valueOf(false));
    private static final AnimationBuilder CHARGE = new AnimationBuilder().addAnimation("move.charge", Boolean.valueOf(true));
    private static final AnimationBuilder BELLY_DRUM = new AnimationBuilder().addAnimation("misc.belly_drum", Boolean.valueOf(false));

    public SmashEntity(EntityType<? extends AoABoss> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.25f;
    }

    @Override
    protected void addSwingData(Int2ObjectOpenHashMap<AoABoss.SwingData> states) {
        states.put(0, (Object)new AoABoss.SwingData(20, 13, new AnimationBuilder().addAnimation("attack.axe_swing", Boolean.valueOf(false))));
        states.put(1, (Object)new AoABoss.SwingData(20, 16, new AnimationBuilder().addAnimation("attack.axe_slam", Boolean.valueOf(false))));
        states.put(2, (Object)new AoABoss.SwingData(0, 0, new AnimationBuilder().addAnimation("attack.axe_slam", Boolean.valueOf(false))));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AoASounds.ENTITY_SMASH_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AoASounds.ENTITY_SMASH_DEATH.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)AoASounds.ENTITY_SMASH_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        return (SoundEvent)AoASounds.ENTITY_GENERIC_HEAVY_STEP.get();
    }

    @Override
    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 3.0625f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ENRAGED, (Object)false);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if ((double)EntityUtil.getCurrentHealthPercent((LivingEntity)this) < 0.25 && !this.isEnraged()) {
            this.enrage();
        }
    }

    protected void enrage() {
        if (!this.isEnraged()) {
            this.m_20088_().m_135381_(ENRAGED, (Object)true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22281_, ENRAGED_DAMAGE_MOD, true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22284_, ENRAGED_ARMOUR_MOD, true);
            EntityUtil.applyAttributeModifierSafely((LivingEntity)this, Attributes.f_22285_, ENRAGED_TOUGHNESS_MOD, true);
            this.triggerAnim((Entity)this, "enrage");
            BrainUtils.setForgettableMemory((LivingEntity)this, (MemoryModuleType)MemoryModuleType.f_26373_, (Object)true, (int)50);
        }
    }

    public boolean isEnraged() {
        return (Boolean)this.m_20088_().m_135370_(ENRAGED);
    }

    public boolean m_213824_() {
        return !this.isAttackState(1);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Enraged", this.isEnraged());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Enraged")) {
            this.m_20088_().m_135381_(ENRAGED, (Object)compound.m_128471_("Enraged"));
        }
    }

    public List<ExtendedSensor<AoABoss>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new HurtBySensor(), new UnreachableTargetSensor().afterScanning(entity -> {
            if (!BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get())) && !this.isAttackState(2)) {
                this.setAttackState(0);
            }
        })});
    }

    public BrainActivityGroup<AoABoss> getCoreTasks() {
        return BrainActivityGroup.coreTasks((Behavior[])new Behavior[]{new LookAtTarget().startCondition(entity -> !this.isAttackState(2)), new WalkOrRunToWalkTarget().startCondition(entity -> !this.isAttackState(2))});
    }

    public BrainActivityGroup<AoABoss> getIdleTasks() {
        return BrainActivityGroup.idleTasks((Behavior[])new Behavior[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate().useMemory(MemoryModuleType.f_148206_).startCondition(entity -> !this.isAttackState(2)), new Idle().runFor(entity -> entity.m_217043_().m_216339_(15, 45))}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(0.9f), new Idle().runFor(entity -> entity.m_217043_().m_216339_(30, 60))})});
    }

    public BrainActivityGroup<AoABoss> getFightTasks() {
        return BrainActivityGroup.fightTasks((Behavior[])new Behavior[]{new StopAttackingIfTargetInvalid(target -> !target.m_6084_() || target instanceof Player && ((Player)target).m_7500_()), new SetWalkTargetToAttackTarget().speedMod(1.1f).startCondition(entity -> !this.isAttackState(2)), new FirstApplicableBehaviour(new ExtendedBehaviour[]{new OneRandomBehaviour(new Pair[]{Pair.of((Object)new GroundSlamAttack(this.getSwingWarmupTicks(1)).requiresTarget().cooldownFor(entity -> (int)((float)this.getSwingDurationTicks(1) * entity.m_217043_().m_188501_() * 2.0f)).startCondition(mob -> this.isAttackState(1)).whenStarting(entity -> this.setAttackState(1)).whenStopping(entity -> this.setAttackState(0)), (Object)20), Pair.of((Object)new FleeTarget().fleeDistance(40).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.TARGET_UNREACHABLE.get())) && this.isEnraged()), (Object)1)}), new ReactToUnreachableTarget().timeBeforeReacting(entity -> 100).reaction((entity, isTowering) -> {
            this.enrage();
            this.setAttackState(1);
        }), new AnimatableMeleeAttack(this.getSwingWarmupTicks(0)).attackInterval(entity -> this.getSwingDurationTicks(0) + entity.m_217043_().m_216339_(15, 25)).startCondition(mob -> this.isAttackState(0)), new OneRandomBehaviour(new ExtendedBehaviour[]{new CustomBehaviour(entity -> {
            this.triggerAnim((Entity)this, "belly_drum");
            EntityUtil.applyPotions((Entity)entity, new EffectBuilder(MobEffects.f_19606_, 100).level(2), new EffectBuilder(MobEffects.f_19596_, 100), new EffectBuilder(MobEffects.f_19600_, 100).level(2));
        }).startCondition(entity -> BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.f_26372_) && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.SPECIAL_ATTACK_COOLDOWN.get()))).cooldownFor(entity -> entity.m_217043_().m_216339_(200, 400)).whenStopping(entity -> BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150)), new ChargeAttack(38).speedModifier(1.5f).whenStarting(entity -> {
            this.triggerAnim((Entity)this, "charge_up");
            this.setAttackState(2);
        }).whenStopping(entity -> {
            this.setAttackState(0);
            BrainUtils.setForgettableMemory((LivingEntity)entity, (MemoryModuleType)((MemoryModuleType)AoABrainMemories.SPECIAL_ATTACK_COOLDOWN.get()), (Object)true, (int)150);
        }).cooldownFor(entity -> entity.m_217043_().m_216339_(200, 400))})})});
    }

    @Override
    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "legs_controller", 0.0f, event -> {
            if (event.isMoving()) {
                event.getController().setAnimation(this.m_20142_() ? RUN_BOTTOM_HALF : WALK_BOTTOM_HALF);
                return PlayState.CONTINUE;
            }
            return PlayState.STOP;
        }));
        animationData.addAnimationController(new AoAAnimationController<SmashEntity>(this, "arms_controller", 3.0f, event -> {
            AnimationController controller = event.getController();
            if (this.isAttackState(2)) {
                controller.setAnimation(CHARGE);
                return PlayState.CONTINUE;
            }
            if (this.f_20911_) {
                controller.setAnimation(this.getSwingAnim(this.getAttackState()));
                return PlayState.CONTINUE;
            }
            if (controller.getCurrentAnimation() != null && !controller.getCurrentAnimation().animationName.startsWith("move")) {
                controller.markNeedsReload();
            }
            if (event.isMoving()) {
                controller.setAnimation(this.m_20142_() ? RUN_TOP_HALF : WALK_TOP_HALF);
            } else {
                controller.setAnimation(this.isEnraged() ? ENRAGED_IDLE : AoAAnimations.IDLE);
            }
            return PlayState.CONTINUE;
        }).triggerable("enrage", ENRAGE).triggerable("belly_drum", BELLY_DRUM).triggerable("charge_up", CHARGE_UP));
    }
}

