/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.boss;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeHooks;
import net.tslat.aoa3.common.misc.AoAAnimatable;
import net.tslat.aoa3.common.misc.AoAAnimationFactory;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.util.BrainUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.manager.AnimationData;

public abstract class AoABoss
extends Monster
implements AoAAnimatable<AoABoss>,
SmartBrainOwner<AoABoss> {
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AoABoss.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.m_135353_(AoABoss.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final ServerBossEvent bossStatusTracker = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_20).m_7003_(false).m_7006_(false);
    private final AoAAnimationFactory<AoABoss> animationFactory = new AoAAnimationFactory<AoABoss>(this);
    private Int2ObjectOpenHashMap<SwingData> attackStates;

    protected AoABoss(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.bossStatusTracker.f_18847_ = this.m_20148_();
    }

    private void checkAndPrepAttackStates() {
        if (this.attackStates == null) {
            this.attackStates = new Int2ObjectOpenHashMap();
            this.addSwingData(this.attackStates);
        }
    }

    protected void addSwingData(Int2ObjectOpenHashMap<SwingData> states) {
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_STATE, (Object)0);
        this.m_20088_().m_135372_(INVULNERABLE, (Object)false);
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @javax.annotation.Nullable SpawnGroupData spawnData, @javax.annotation.Nullable CompoundTag dataTag) {
        this.f_21364_ = reason == MobSpawnType.MOB_SUMMONED ? 0 : 2 * (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22281_) * 2.0) / 10.0);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    @javax.annotation.Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.m_60767_().m_76332_()) {
            BlockState state = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType blockSound = state.m_60734_() == Blocks.f_50125_ ? state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockState.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            return blockSound.m_56776_();
        }
        return null;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossStatusTracker.m_6456_(this.m_5446_());
        }
        this.bossStatusTracker.f_18847_ = this.m_20148_();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossStatusTracker.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        this.bossStatusTracker.m_142711_(this.m_21223_() / this.m_21233_());
        this.tickBrain((LivingEntity)this);
    }

    protected AnimationBuilder getSwingAnim(int state) {
        this.checkAndPrepAttackStates();
        return ((SwingData)this.attackStates.get((int)state)).anim;
    }

    protected int getSwingDurationTicks(int state) {
        this.checkAndPrepAttackStates();
        return ((SwingData)this.attackStates.get((int)state)).animLength;
    }

    protected int getSwingWarmupTicks(int state) {
        this.checkAndPrepAttackStates();
        return ((SwingData)this.attackStates.get((int)state)).warmupTicks;
    }

    public int m_21304_() {
        return this.getSwingDurationTicks(this.getAttackState());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossStatusTracker.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossStatusTracker.m_6539_(player);
    }

    public void m_20331_(boolean isInvulnerable) {
        super.m_20331_(isInvulnerable);
        this.m_20088_().m_135381_(INVULNERABLE, (Object)isInvulnerable);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(INVULNERABLE)) {
            this.m_20331_((Boolean)this.m_20088_().m_135370_(INVULNERABLE));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.m_20331_(this.m_20147_());
    }

    public boolean isAttackState(int state) {
        return this.getAttackState() == state;
    }

    public int getAttackState() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.m_20088_().m_135381_(ATTACK_STATE, (Object)state);
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.f_21364_ > 0;
    }

    @javax.annotation.Nullable
    public LivingEntity m_5448_() {
        return BrainUtils.getTargetOfEntity((LivingEntity)this, (LivingEntity)super.m_5448_());
    }

    public abstract void registerControllers(AnimationData var1);

    @Override
    public AoAAnimationFactory<AoABoss> getFactory() {
        return this.animationFactory;
    }

    protected Brain.Provider<AoABoss> m_5490_() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public void m_6667_(DamageSource cause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)cause)) {
            return;
        }
        if (!this.m_213877_() && !this.f_20890_) {
            Entity lastAttacker = cause.m_7639_();
            LivingEntity killer = this.m_21232_();
            if (this.f_20897_ >= 0 && killer != null) {
                killer.m_5993_((Entity)this, this.f_20897_, cause);
            }
            if (this.m_5803_()) {
                this.m_5796_();
            }
            this.f_20890_ = true;
            if (this.f_19853_ instanceof ServerLevel) {
                if (lastAttacker == null || lastAttacker.m_214076_((ServerLevel)this.f_19853_, (LivingEntity)this)) {
                    this.m_146850_(GameEvent.f_223707_);
                    this.m_6668_(cause);
                    this.m_21268_(killer);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)3);
            }
            this.m_21231_().m_19296_();
            this.m_20124_(Pose.DYING);
        }
    }

    protected record SwingData(int animLength, int warmupTicks, AnimationBuilder anim) {
    }
}

