/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.base;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.aoa3.content.entity.ai.mob.ExtendedMeleeAttackGoal;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public abstract class AoAMeleeMob
extends Monster
implements IAnimatable {
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(AoAMeleeMob.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final AttributeModifier SLOW_FALLING = new AttributeModifier(UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA"), "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    protected static final EntityDataAccessor<Boolean> INVULNERABLE = SynchedEntityData.m_135353_(AoAMeleeMob.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected boolean isSlipperyMovement = false;
    private final AnimationFactory animationFactory = new AnimationFactory((IAnimatable)this);

    protected AoAMeleeMob(EntityType<? extends Monster> entityType, Level world) {
        super(entityType, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new ExtendedMeleeAttackGoal<AoAMeleeMob>(this).attackInterval((IntProvider)ConstantInt.m_146483_((int)this.m_21304_())).actionTelegraphTicks(this.getPreAttackTime()).onStart(goal -> this.m_20115_(3, true)).onStop(goal -> this.m_20115_(3, false)));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_STATE, (Object)0);
        this.m_20088_().m_135372_(INVULNERABLE, (Object)false);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.f_21364_ = reason == MobSpawnType.MOB_SUMMONED ? 0 : (int)(5.0 + (this.m_21133_(Attributes.f_22276_) + this.m_21133_(Attributes.f_22284_) * 1.75 + this.m_21133_(Attributes.f_22281_) * 2.0) / 10.0);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @Nullable
    protected SoundEvent m_5592_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return null;
    }

    protected int getAttackSwingDuration() {
        return 6;
    }

    protected int getPreAttackTime() {
        return 0;
    }

    @Nullable
    protected SoundEvent getStepSound(BlockPos pos, BlockState blockState) {
        if (!blockState.m_60767_().m_76332_()) {
            BlockState state = this.f_19853_.m_8055_(pos.m_7494_());
            SoundType blockSound = state.m_60734_() == Blocks.f_50125_ ? state.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this) : blockState.getSoundType((LevelReader)this.f_19853_, pos, (Entity)this);
            return blockSound.m_56776_();
        }
        return null;
    }

    protected void onAttack(Entity target) {
    }

    protected void onHit(DamageSource source, float amount) {
    }

    public void m_20331_(boolean isInvulnerable) {
        super.m_20331_(isInvulnerable);
        this.m_20088_().m_135381_(INVULNERABLE, (Object)isInvulnerable);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key.equals(INVULNERABLE)) {
            this.m_20331_((Boolean)this.m_20088_().m_135370_(INVULNERABLE));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.m_20331_(this.m_20147_());
    }

    public int getAttackState() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.m_20088_().m_135381_(ATTACK_STATE, (Object)state);
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        SoundEvent stepSound = this.getStepSound(pos, blockIn);
        if (stepSound != null) {
            this.m_5496_(stepSound, 0.15f, 1.0f);
        }
    }

    public boolean m_7327_(Entity target) {
        if (super.m_7327_(target)) {
            this.onAttack(target);
            return true;
        }
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.onHit(source, amount);
            return true;
        }
        return false;
    }

    protected boolean m_6125_() {
        return super.m_6125_() && this.f_21364_ > 0;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return true;
    }

    public int m_21304_() {
        int time = this.getAttackSwingDuration();
        if (MobEffectUtil.m_19584_((LivingEntity)this)) {
            time -= 1 + MobEffectUtil.m_19586_((LivingEntity)this);
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            time += (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return time;
    }

    public void registerControllers(AnimationData animationData) {
    }

    public AnimationFactory getFactory() {
        return this.animationFactory;
    }
}

