/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.tslat.aoa3.content.entity.ai.ExtendedGoal;
import net.tslat.aoa3.util.RandomUtil;

public class ExtendedMeleeAttackGoal<T extends Mob>
extends ExtendedGoal<T> {
    protected double speedModifier = 1.0;
    protected boolean ignoreLineOfSight = false;
    protected double attackReach;
    protected IntProvider attackInterval = ConstantInt.m_146483_((int)20);
    protected Path currentPath;
    protected Vec3 targetLocation;
    protected int newPathCooldown;
    protected int attackCooldown;
    protected long goalTimeoutCounter;

    public ExtendedMeleeAttackGoal(T entity) {
        super(entity);
        this.attackReach = (double)entity.m_20205_() * 1.75 + (double)entity.m_20192_() / 3.6 * 0.25;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public ExtendedMeleeAttackGoal<T> speedModifier(double modifier) {
        this.speedModifier = modifier;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> ignoreLineOfSight() {
        this.ignoreLineOfSight = true;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> attackReach(double reach) {
        this.attackReach = reach;
        return this;
    }

    public ExtendedMeleeAttackGoal<T> attackInterval(IntProvider tickValueProvider) {
        this.attackInterval = tickValueProvider;
        return this;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        long gameTime = this.entity.f_19853_.m_46467_();
        if (gameTime - this.goalTimeoutCounter < 20L) {
            return false;
        }
        if (this.entity.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        this.goalTimeoutCounter = gameTime;
        LivingEntity target = this.entity.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        this.currentPath = this.entity.m_21573_().m_6570_((Entity)target, 0);
        if (this.currentPath != null) {
            return true;
        }
        return this.getAttackReachSqr(target) >= this.entity.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.entity.m_21573_().m_26536_(this.currentPath, this.speedModifier);
        this.entity.m_21561_(true);
        this.newPathCooldown = 0;
        this.attackCooldown = 0;
    }

    @Override
    public boolean m_8045_() {
        if (!super.m_8045_()) {
            return false;
        }
        LivingEntity target = this.entity.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        if (target.m_5833_() || target instanceof Player && ((Player)target).m_7500_()) {
            return false;
        }
        if (this.isTelegraphingAction()) {
            return true;
        }
        if (!this.ignoreLineOfSight) {
            return !this.entity.m_21573_().m_26571_();
        }
        return this.entity.m_21444_(target.m_20183_());
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.entity.m_5448_();
        double targetDistance = this.entity.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        if (this.newPathCooldown > 0) {
            --this.newPathCooldown;
        }
        this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (this.newPathCooldown <= 0 && (this.ignoreLineOfSight || this.entity.m_21574_().m_148306_((Entity)target)) && (this.targetLocation == null || target.m_20238_(this.targetLocation) >= 1.0 || RandomUtil.oneInNChance(20))) {
            this.targetLocation = target.m_20182_();
            this.newPathCooldown = RandomUtil.randomNumberBetween(4, 11);
            if (targetDistance > 256.0) {
                this.newPathCooldown += 5;
                if (targetDistance > 1024.0) {
                    this.newPathCooldown += 5;
                }
            }
            if (!this.entity.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                this.newPathCooldown += 15;
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        this.checkAndPerformAttack(target, targetDistance);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.entity.m_21561_(false);
        this.entity.m_21573_().m_26573_();
    }

    protected void checkAndPerformAttack(LivingEntity target, double sqrDistToTarget) {
        if (sqrDistToTarget <= this.getAttackReachSqr(target)) {
            if (this.attackCooldown <= 0) {
                this.attackCooldown = this.attackInterval.m_214085_((RandomSource)RandomUtil.RANDOM);
                this.startTelegraphingNextAction();
                this.entity.m_6674_(InteractionHand.MAIN_HAND);
                return;
            }
            if (this.hasActionTelegraphFinished()) {
                this.entity.m_7327_((Entity)target);
                this.resetActionTelegraph();
            }
        } else {
            this.resetActionTelegraph();
        }
    }

    protected double getAttackReachSqr(LivingEntity target) {
        double targetBBOffset = (double)target.m_20205_() * 0.5;
        return this.attackReach * this.attackReach + targetBBOffset * targetBBOffset;
    }
}

