/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.entity.ai.mob;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.tslat.aoa3.content.entity.ai.ExtendedTargetGoal;
import net.tslat.aoa3.util.EntityRetrievalUtil;

public class ExtendedFindNearbyTargetGoal<T extends Mob>
extends ExtendedTargetGoal<T> {
    protected final Predicate targetPredicate;
    protected final boolean onlyPlayers;
    protected double radius;

    public ExtendedFindNearbyTargetGoal(T entity, boolean onlyPlayers, Predicate<? extends Entity> targetPredicate) {
        super(entity);
        this.targetPredicate = targetPredicate;
        this.onlyPlayers = onlyPlayers;
        this.radius = this.getTargetingRange();
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
    }

    public ExtendedFindNearbyTargetGoal<T> searchRadius(double radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_()) {
            return false;
        }
        this.target = this.findTarget();
        return this.target != null;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.entity.m_6710_(this.target);
    }

    protected LivingEntity findTarget() {
        if (this.onlyPlayers) {
            return EntityRetrievalUtil.getNearestPlayer((Entity)this.entity, this.radius, this.targetPredicate);
        }
        return (LivingEntity)EntityRetrievalUtil.getNearestEntity((Entity)this.entity, this.radius, entity -> entity instanceof LivingEntity && this.targetPredicate.test(entity));
    }
}

