/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.capability.persistentstack;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.FloatTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapability;
import net.tslat.aoa3.content.capability.persistentstack.PersistentStackCapabilityHandles;

public class PersistentStackCapabilityProvider
implements ICapabilitySerializable<FloatTag> {
    public static final ResourceLocation ID = new ResourceLocation("aoa3", "persistent_stack");
    public static final Capability<PersistentStackCapabilityHandles> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PersistentStackCapabilityHandles>(){});
    private final LazyOptional<PersistentStackCapability> implContainer = LazyOptional.of(PersistentStackCapability::new);
    private final Direction dir;

    public PersistentStackCapabilityProvider(@Nullable Direction dir) {
        this.dir = dir;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY == cap && this.dir == side ? this.implContainer.cast() : LazyOptional.empty();
    }

    public FloatTag serializeNBT() {
        if (!this.implContainer.isPresent()) {
            return FloatTag.f_128559_;
        }
        return ((PersistentStackCapability)this.implContainer.resolve().get()).serializeNBT();
    }

    public void deserializeNBT(FloatTag nbt) {
        this.implContainer.ifPresent(cap -> cap.deserializeNBT(nbt));
    }

    public static PersistentStackCapabilityHandles getOrDefault(ItemStack stack, Direction side) {
        return (PersistentStackCapabilityHandles)stack.getCapability(CAPABILITY, side).orElse((Object)new PersistentStackCapability());
    }
}

