/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.utility;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.tileentity.BossAltarTileEntity;
import net.tslat.aoa3.content.item.misc.summoning.BossSpawningItem;
import net.tslat.aoa3.data.server.AoANowhereBossArenaListener;
import net.tslat.aoa3.scheduling.AoAScheduler;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.EntityRetrievalUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class BossAltar
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = BlockUtil.pixelBasedCube(4, 0, 4, 12, 12, 12);

    public BossAltar() {
        super(new BlockUtil.CompactProperties(Material.f_76281_, MaterialColor.f_76365_).unbreakable().light(2).emissive().noOcclusion().get());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BossAltarTileEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BossSpawningItem bossItem;
        EntityType entityType;
        if (!WorldUtil.isWorld(level, AoADimensions.NOWHERE.key) || level.m_46791_() == Difficulty.PEACEFUL) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        Item item = heldItem.m_41720_();
        if (!(item instanceof BossSpawningItem) || (entityType = (bossItem = (BossSpawningItem)item).getEntityType(heldItem)) == null) {
            if (hand == InteractionHand.OFF_HAND) {
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.badItem"));
            }
            return InteractionResult.FAIL;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            AABB teleportBounds = new AABB((double)(pos.m_123341_() - 3), (double)pos.m_123342_(), (double)(pos.m_123343_() - 3), (double)(pos.m_123341_() + 4), (double)(pos.m_123342_() + 3), (double)(pos.m_123343_() + 3));
            List<Player> players = EntityRetrievalUtil.getPlayers(level, teleportBounds, LivingEntity::m_6084_);
            if (players.isEmpty()) {
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.tooFar", ChatFormatting.RED, new Component[0]));
                return InteractionResult.FAIL;
            }
            AoANowhereBossArenaListener.NowhereBossArena arena = AoANowhereBossArenaListener.getFreeArena(serverLevel);
            if (arena == null) {
                player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.full", ChatFormatting.RED, new Component[0]));
            } else {
                BlockEntity blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof BossAltarTileEntity) {
                    BossAltarTileEntity bossAltar = (BossAltarTileEntity)blockEntity;
                    if (bossAltar.getCurrentEntity() != null) {
                        player.m_213846_((Component)LocaleUtil.getLocaleMessage("message.feedback.nowhere.boss.inUse", ChatFormatting.RED, new Component[0]));
                        return InteractionResult.FAIL;
                    }
                    bossAltar.updateEntity(entityType);
                    AoAScheduler.scheduleSyncronisedTask(() -> bossAltar.updateEntity(null), 95);
                }
                arena.placePlayersAndBoss(serverLevel, players, pl -> pl.m_9236_() == level && pl.m_6084_() && teleportBounds.m_82390_(pl.m_20182_()), bossItem::spawnBoss);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

