/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.misc;

import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.block.AoABlockEntities;
import net.tslat.aoa3.common.registration.block.AoABlocks;
import net.tslat.aoa3.content.block.WaterloggableBlock;
import net.tslat.aoa3.content.block.tileentity.TrophyTileEntity;
import net.tslat.aoa3.util.BlockUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class TrophyBlock
extends WaterloggableBlock
implements EntityBlock {
    private static final VoxelShape FULL_AABB = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.m_49796_((double)4.5, (double)9.0, (double)4.5, (double)11.5, (double)11.0, (double)11.5)});

    public TrophyBlock() {
        super(new BlockUtil.CompactProperties(new Material(MaterialColor.f_76366_, false, false, true, false, false, false, PushReaction.BLOCK), MaterialColor.f_76409_).stats(10.0f, 2000.0f).get());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return FULL_AABB;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyTileEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType != AoABlockEntities.TROPHY.get()) {
            return null;
        }
        if (!level.m_5776_()) {
            return null;
        }
        return (entityLevel, entityPos, entityState, blockEntity) -> TrophyTileEntity.doClientTick(entityLevel, entityPos, entityState, (TrophyTileEntity)blockEntity);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity tile;
        CompoundTag dataTag;
        CompoundTag tag;
        if (stack.m_41782_() && (tag = stack.m_41783_()).m_128441_("BlockEntityTag") && (dataTag = tag.m_128469_("BlockEntityTag")).m_128425_("EntityID", 8) && (tile = world.m_7702_(pos)) instanceof TrophyTileEntity) {
            ((TrophyTileEntity)tile).setEntity(dataTag.m_128461_("EntityID"), dataTag.m_128441_("OriginalTrophy") && !dataTag.m_128471_("OriginalTrophy"));
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!WorldUtil.canModifyBlock((LevelAccessor)world, pos, (Entity)player, heldStack)) {
            return InteractionResult.FAIL;
        }
        if (heldStack.m_41720_() instanceof SpawnEggItem) {
            BlockEntity tile = world.m_7702_(pos);
            SpawnEggItem egg = (SpawnEggItem)heldStack.m_41720_();
            if (tile instanceof TrophyTileEntity) {
                ((TrophyTileEntity)tile).setEntity(ForgeRegistries.ENTITY_TYPES.getKey((Object)egg.m_43228_(heldStack.m_41783_())).toString(), true);
                if (!world.m_5776_() && !player.m_7500_()) {
                    heldStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TrophyTileEntity trophyTile;
        ItemStack stack = new ItemStack((ItemLike)this.m_5456_());
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TrophyTileEntity && (trophyTile = (TrophyTileEntity)tile).getEntityId() != null) {
            CompoundTag nbt = new CompoundTag();
            CompoundTag dataTag = new CompoundTag();
            dataTag.m_128359_("EntityID", ((TrophyTileEntity)tile).getEntityId());
            dataTag.m_128379_("OriginalTrophy", ((TrophyTileEntity)tile).isOriginal());
            nbt.m_128365_("BlockEntityTag", (Tag)dataTag);
            stack.m_41751_(nbt);
            if (trophyTile.getCachedEntity() != null) {
                Entity cachedEntity = ((TrophyTileEntity)tile).getCachedEntity();
                MutableComponent entityName = cachedEntity == null ? Component.m_237113_((String)"") : cachedEntity.m_7755_();
                stack.m_41714_((Component)LocaleUtil.getLocaleMessage("block.aoa3.trophy.desc", new Component[]{entityName}));
            }
        }
        return stack;
    }

    public static CompoundTag getTagForEntity(EntityType<?> entity) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag dataTag = new CompoundTag();
        dataTag.m_128359_("EntityID", ForgeRegistries.ENTITY_TYPES.getKey(entity).toString());
        dataTag.m_128379_("OriginalTrophy", true);
        nbt.m_128365_("BlockEntityTag", (Tag)dataTag);
        return nbt;
    }

    public static ItemStack cloneTrophy(ItemStack sourceTrophy, ItemLike destTrophy) {
        CompoundTag sourceTag = sourceTrophy.m_41784_();
        ItemStack newStack = new ItemStack((ItemLike)destTrophy.m_5456_());
        CompoundTag destTag = newStack.m_41784_();
        try {
            if (sourceTag.m_128456_()) {
                return newStack;
            }
            if (sourceTag.m_128441_("BlockEntityTag")) {
                destTag.m_128365_("BlockEntityTag", (Tag)sourceTag.m_128469_("BlockEntityTag"));
            }
            if (sourceTag.m_128441_("display")) {
                CompoundTag displayTag = new CompoundTag();
                String localePrefix = "block.aoa3.trophy.desc";
                if (destTrophy == AoABlocks.GOLD_TROPHY.get()) {
                    localePrefix = "block.aoa3.gold_trophy.desc";
                } else if (destTrophy == AoABlocks.ORNATE_TROPHY.get()) {
                    localePrefix = "block.aoa3.ornate_trophy.desc";
                }
                if (sourceTag.m_128441_("BlockEntityTag")) {
                    displayTag.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237110_((String)localePrefix, (Object[])new Object[]{Component.m_237115_((String)Util.m_137492_((String)"entity", (ResourceLocation)new ResourceLocation(sourceTag.m_128469_("BlockEntityTag").m_128461_("EntityID"))))})));
                } else {
                    displayTag = sourceTag.m_128469_("display");
                }
                destTag.m_128365_("display", (Tag)displayTag);
            }
        }
        catch (Exception ex) {
            Logging.logMessage(org.apache.logging.log4j.Level.ERROR, "Failed to clone trophy data.", ex);
        }
        return newStack;
    }

    public static CompoundTag getOriginalTrophyTag(EntityType<?> entity, Block trophyBlock) {
        CompoundTag tag = TrophyBlock.getTagForEntity(entity);
        CompoundTag displayTag = new CompoundTag();
        String localePrefix = "block.aoa3.trophy.desc";
        if (trophyBlock == AoABlocks.GOLD_TROPHY.get()) {
            localePrefix = "block.aoa3.gold_trophy.desc";
        } else if (trophyBlock == AoABlocks.ORNATE_TROPHY.get()) {
            localePrefix = "block.aoa3.ornate_trophy.desc";
        }
        displayTag.m_128359_("Name", Component.Serializer.m_130703_((Component)Component.m_237110_((String)localePrefix, (Object[])new Object[]{Component.m_237115_((String)entity.m_20675_())})));
        tag.m_128365_("display", (Tag)displayTag);
        return tag;
    }
}

