/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.content.block.functional.altar;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.tslat.aoa3.common.registration.item.AoAItems;
import net.tslat.aoa3.common.registration.worldgen.AoADimensions;
import net.tslat.aoa3.content.block.functional.altar.BossAltarBlock;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.PlayerUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ClunkheadAltar
extends BossAltarBlock {
    public ClunkheadAltar() {
        super(MaterialColor.f_76415_);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (this.getActivationItem() != null && heldItem.m_41720_() != this.getActivationItem()) {
            return InteractionResult.PASS;
        }
        if (player instanceof ServerPlayer && (this.getActivationItem() == null || heldItem.m_41720_() == this.getActivationItem())) {
            if (world.m_46791_() == Difficulty.PEACEFUL) {
                PlayerUtil.notifyPlayer(player, (Component)Component.m_237115_((String)"message.feedback.spawnBoss.difficultyFail"));
                return InteractionResult.FAIL;
            }
            if (this.checkActivationConditions(player, hand, state, pos)) {
                if (!player.m_7500_()) {
                    ItemUtil.damageItem(heldItem, (LivingEntity)player, hand);
                }
                this.doActivationEffect(player, hand, state, pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void doActivationEffect(Player player, InteractionHand hand, BlockState state, BlockPos blockPos) {
    }

    @Override
    protected boolean checkActivationConditions(Player player, InteractionHand hand, BlockState state, BlockPos pos) {
        return WorldUtil.isWorld(player.f_19853_, AoADimensions.RUNANDOR.key);
    }

    @Override
    protected Item getActivationItem() {
        return (Item)AoAItems.MEGA_RUNE_STONE.get();
    }
}

