/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.worldgen;

import com.google.common.collect.HashBiMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class AoADimensions {
    private static final HashBiMap<ResourceKey<Level>, AoADimension> dimTypeMap = HashBiMap.create((int)25);
    public static final DimensionContainer ABYSS = new DimensionContainer("abyss", AoADimension.ABYSS);
    public static final DimensionContainer BARATHOS = new DimensionContainer("barathos", AoADimension.BARATHOS);
    public static final DimensionContainer CANDYLAND = new DimensionContainer("candyland", AoADimension.CANDYLAND);
    public static final DimensionContainer CELEVE = new DimensionContainer("celeve", AoADimension.CELEVE);
    public static final DimensionContainer CREEPONIA = new DimensionContainer("creeponia", AoADimension.CREEPONIA);
    public static final DimensionContainer CRYSTEVIA = new DimensionContainer("crystevia", AoADimension.CRYSTEVIA);
    public static final DimensionContainer DEEPLANDS = new DimensionContainer("deeplands", AoADimension.DEEPLANDS);
    public static final DimensionContainer DUSTOPIA = new DimensionContainer("dustopia", AoADimension.DUSTOPIA);
    public static final DimensionContainer THE_END = new DimensionContainer((ResourceKey<Level>)Level.f_46430_, AoADimension.THE_END);
    public static final DimensionContainer GARDENCIA = new DimensionContainer("gardencia", AoADimension.GARDENCIA);
    public static final DimensionContainer GRECKON = new DimensionContainer("greckon", AoADimension.GRECKON);
    public static final DimensionContainer HAVEN = new DimensionContainer("haven", AoADimension.HAVEN);
    public static final DimensionContainer IROMINE = new DimensionContainer("iromine", AoADimension.IROMINE);
    public static final DimensionContainer LBOREAN = new DimensionContainer("lborean", AoADimension.LBOREAN);
    public static final DimensionContainer LELYETIA = new DimensionContainer("lelyetia", AoADimension.LELYETIA);
    public static final DimensionContainer LUNALUS = new DimensionContainer("lunalus", AoADimension.LUNALUS);
    public static final DimensionContainer MYSTERIUM = new DimensionContainer("mysterium", AoADimension.MYSTERIUM);
    public static final DimensionContainer NETHER = new DimensionContainer((ResourceKey<Level>)Level.f_46429_, AoADimension.NETHER);
    public static final DimensionContainer NOWHERE = new DimensionContainer("nowhere", AoADimension.NOWHERE);
    public static final DimensionContainer OVERWORLD = new DimensionContainer((ResourceKey<Level>)Level.f_46428_, AoADimension.OVERWORLD);
    public static final DimensionContainer PRECASIA = new DimensionContainer("precasia", AoADimension.PRECASIA);
    public static final DimensionContainer RUNANDOR = new DimensionContainer("runandor", AoADimension.RUNANDOR);
    public static final DimensionContainer SHYRELANDS = new DimensionContainer("shyrelands", AoADimension.SHYRELANDS);
    public static final DimensionContainer VOX_PONDS = new DimensionContainer("vox_ponds", AoADimension.VOX_PONDS);

    @Nullable
    public static AoADimension getDim(@Nonnull ResourceKey<Level> key) {
        return (AoADimension)((Object)dimTypeMap.get(key));
    }

    @Nullable
    public static ResourceKey<Level> getWorldKey(@Nonnull AoADimension dim) {
        return (ResourceKey)dimTypeMap.inverse().get((Object)dim);
    }

    public static enum AoADimension {
        ABYSS,
        BARATHOS,
        CANDYLAND,
        CELEVE,
        CREEPONIA,
        CRYSTEVIA,
        DEEPLANDS,
        THE_END,
        DUSTOPIA,
        GARDENCIA,
        GRECKON,
        HAVEN,
        IROMINE,
        LBOREAN,
        LELYETIA,
        LUNALUS,
        MYSTERIUM,
        NETHER,
        NOWHERE,
        OVERWORLD,
        PRECASIA,
        RUNANDOR,
        SHYRELANDS,
        VOX_PONDS;

    }

    public static class DimensionContainer {
        public final ResourceKey<Level> key;
        public final AoADimension dim;
        private ServerLevel world = null;

        private DimensionContainer(ResourceKey<Level> key, AoADimension dim) {
            this.key = key;
            this.dim = dim;
            dimTypeMap.put(key, (Object)dim);
        }

        private DimensionContainer(String dimId, AoADimension dim) {
            this((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation("aoa3", dimId)), dim);
        }

        @Nullable
        public ServerLevel getWorld() {
            if (this.world != null) {
                return this.world;
            }
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return null;
            }
            this.world = ServerLifecycleHooks.getCurrentServer().m_129880_(this.key);
            return this.world;
        }
    }
}

