/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import net.tslat.aoa3.common.registration.entity.AoAAnimals;
import net.tslat.aoa3.common.registration.entity.AoAMobs;
import net.tslat.aoa3.content.entity.base.AbstractLavaFishEntity;
import net.tslat.aoa3.util.WorldUtil;
import org.apache.logging.log4j.Level;

public final class AoAEntitySpawnPlacements {
    public static void lateInit() {
        Logging.logStatusMessage("Setting entity spawn placements");
        AoAEntitySpawnPlacements.setOverworldSpawnPlacements();
    }

    public static void setOverworldSpawnPlacements() {
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.ICE_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.LEAFY_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.STONE_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.SAND_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.WOOD_GIANT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CHARGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.KING_CHARGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CYCLOPS.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.monsterPredicate(true, 55, Integer.MAX_VALUE));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.CHOMPER.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.DEFAULT_DAY_MONSTER);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.SASQUATCH.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.monsterPredicate(true, 55, Integer.MAX_VALUE));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.BUSH_BABY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, SpawnPredicates.monsterPredicate(true, 65, Integer.MAX_VALUE));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAMobs.VOID_WALKER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.monsterPredicate(false, Integer.MIN_VALUE, 0));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SHINY_SQUID.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)GlowSquid::m_217017_));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.BLUE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CANDLEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CHARRED_CHAR.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CHOCAW.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_SKIPPER.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.CRIMSON_STRIPEFISH.get(), SpawnPlacements.Type.IN_LAVA, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (SpawnPlacements.SpawnPredicate<? extends Mob>)((SpawnPlacements.SpawnPredicate)AbstractLavaFishEntity::checkFishSpawnRules));
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.DARK_HATCHETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.GREEN_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.HYDRONE.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.IRONBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.JAMFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PARAPIRANHA.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PEARL_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.PURPLE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RAINBOWFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RAZORFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.RED_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.REEFTOOTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.ROCKETFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SAILBACK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SAPPHIRE_STRIDER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.SKELECANTH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.WHITE_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.YELLOW_GEMTRAP.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.TURQUOISE_STRIPEFISH.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
        AoAEntitySpawnPlacements.setSpawnPlacement((EntityType)AoAAnimals.VIOLET_SKIPPER.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SpawnPredicates.FISH);
    }

    private static <T extends Mob> void setSpawnPlacement(EntityType<T> entityType, SpawnPlacements.Type placementType, Heightmap.Types heightmap, SpawnPlacements.SpawnPredicate<? extends Mob> spawnPredicate) {
        try {
            if (SpawnPlacements.m_21752_(entityType) == SpawnPlacements.Type.NO_RESTRICTIONS) {
                SpawnPlacements.m_21754_(entityType, (SpawnPlacements.Type)placementType, (Heightmap.Types)heightmap, spawnPredicate);
            }
        }
        catch (IllegalStateException ex) {
            Logging.logMessage(Level.WARN, "Caught duplicate spawn placement registration from: " + ForgeRegistries.ENTITY_TYPES.getKey(entityType).toString());
        }
    }

    private static final class SpawnPredicates {
        private static final SpawnPlacements.SpawnPredicate<Mob> DEFAULT_MONSTER = SpawnPredicates.monsterPredicate(false, Integer.MIN_VALUE, Integer.MAX_VALUE);
        private static final SpawnPlacements.SpawnPredicate<Mob> DEFAULT_DAY_MONSTER = SpawnPredicates.monsterPredicate(true, Integer.MIN_VALUE, Integer.MAX_VALUE);
        private static final SpawnPlacements.SpawnPredicate<Mob> FISH = (type, world, reason, pos, rand) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);

        private SpawnPredicates() {
        }

        private static SpawnPlacements.SpawnPredicate<Mob> npcPredicate(boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (!Mob.m_217057_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand)) {
                    return false;
                }
                return spawnsInDarkness || WorldUtil.getLightLevel(world, pos, false, false) >= 8;
            };
        }

        private static SpawnPlacements.SpawnPredicate<Mob> monsterPredicate(boolean daySpawn, int minSpawnHeight, int maxSpawnHeight) {
            return (type, world, reason, pos, rand) -> {
                if (world.m_46791_() == Difficulty.PEACEFUL) {
                    return false;
                }
                if (daySpawn) {
                    if (!world.m_6018_().m_46461_()) {
                        return false;
                    }
                    int blockLightLimit = world.m_6042_().m_223570_();
                    if (blockLightLimit < 15 && world.m_45517_(LightLayer.BLOCK, pos) > blockLightLimit) {
                        return false;
                    }
                } else if (!Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)rand)) {
                    return false;
                }
                if (pos.m_123342_() < minSpawnHeight || pos.m_123342_() > maxSpawnHeight) {
                    return false;
                }
                return Mob.m_217057_((EntityType)type, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)rand);
            };
        }

        private static <T extends Mob> SpawnPlacements.SpawnPredicate<T> animalPredicate(@Nullable TagKey<Block> blockTag, boolean spawnsInDarkness) {
            return (type, world, reason, pos, rand) -> {
                if (blockTag != null && !world.m_8055_(pos.m_7495_()).m_204336_(blockTag)) {
                    return false;
                }
                return spawnsInDarkness || world.m_45524_(pos, 0) >= 8;
            };
        }
    }
}

