/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.registration.block;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.RegistryObject;
import net.tslat.aoa3.common.registration.AoARegistries;
import net.tslat.aoa3.content.fluid.ToxicWaste;
import net.tslat.aoa3.util.ColourUtil;

public final class AoAFluidTypes {
    private static final ResourceLocation WATER_STILL_TEXTURE = new ResourceLocation("block/water_still");
    private static final ResourceLocation WATER_FLOWING_TEXTURE = new ResourceLocation("block/water_flow");
    private static final ResourceLocation WATER_OVERLAY_TEXTURE = new ResourceLocation("block/water_overlay");
    private static final ResourceLocation UNDERWATER_TEXTURE = new ResourceLocation("textures/misc/underwater.png");
    public static final RegistryObject<FluidType> TOXIC_WASTE = AoAFluidTypes.register("toxic_waste", ToxicWaste::new);
    public static final RegistryObject<FluidType> CANDIED_WATER = AoAFluidTypes.register("candied_water", () -> new DefaultWaterFluidType(FluidType.Properties.create().canSwim(true).canDrown(true).supportsBoating(true).canHydrate(true).canExtinguish(true).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_11937_).fallDistanceModifier(0.0f).viscosity(1200).density(1200)).colour(ColourUtil.RGBA(255, 105, 180, 200)));

    public static void init() {
    }

    private static <T extends FluidType> RegistryObject<T> register(String id, Supplier<T> fluidType) {
        return AoARegistries.FLUID_TYPES.register(id, fluidType);
    }

    static class DefaultWaterFluidType
    extends FluidType {
        private int colour;

        public DefaultWaterFluidType(FluidType.Properties properties) {
            super(properties);
        }

        DefaultWaterFluidType colour(int colour) {
            this.colour = colour;
            return this;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return WATER_STILL_TEXTURE;
                }

                public ResourceLocation getFlowingTexture() {
                    return WATER_FLOWING_TEXTURE;
                }

                public ResourceLocation getOverlayTexture() {
                    return WATER_OVERLAY_TEXTURE;
                }

                public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                    return UNDERWATER_TEXTURE;
                }

                public int getTintColor() {
                    return colour;
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor();
                }
            });
        }
    }
}

