/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.common.packet.packets.AoAPacket;
import net.tslat.aoa3.library.builder.EntityPredicate;

public class ParticleEffectPacket
implements AoAPacket {
    private final Type type;
    private final int entityId;

    public ParticleEffectPacket(Type type, int entityId) {
        this.type = type;
        this.entityId = entityId;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.type.ordinal());
        buffer.m_130130_(this.entityId);
    }

    public static ParticleEffectPacket decode(FriendlyByteBuf buffer) {
        return new ParticleEffectPacket(Type.values()[buffer.m_130242_()], buffer.m_130242_());
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        switch (this.type) {
            case FREEZING_SNOWFLAKE: {
                Entity entity = context.get().getSender().m_9236_().m_6815_(this.entityId);
                if (entity == null || !((float)entity.m_146888_() <= (float)entity.m_146891_() * 2.5f)) break;
                entity.m_146917_(entity.m_146888_() + 14);
                break;
            }
            case SANDSTORM: {
                Entity entity = context.get().getSender().m_9236_().m_6815_(this.entityId);
                if (entity instanceof LivingEntity) {
                    if (!EntityPredicate.TARGETABLE_ENTITIES.test(entity)) break;
                    entity.m_6469_(DamageSource.f_19319_, 2.0f);
                    break;
                }
                if (!(entity instanceof Projectile)) break;
                entity.m_20256_(entity.m_20184_().m_82542_(-0.5, -0.5, -0.5));
            }
        }
    }

    public static enum Type {
        FREEZING_SNOWFLAKE,
        SANDSTORM;

    }
}

