/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.packets;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.aoa3.client.ClientOperations;
import net.tslat.aoa3.common.misc.AoAAnimatable;
import net.tslat.aoa3.common.packet.packets.AoAPacket;

public class GeckolibAnimationTriggerPacket
implements AoAPacket {
    private final int entityId;
    private final String anim;

    public GeckolibAnimationTriggerPacket(int id, String anim) {
        this.entityId = id;
        this.anim = anim;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.m_130070_(this.anim);
    }

    public static GeckolibAnimationTriggerPacket decode(FriendlyByteBuf buffer) {
        return new GeckolibAnimationTriggerPacket(buffer.m_130242_(), buffer.m_130136_(Short.MAX_VALUE));
    }

    @Override
    public void receiveMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Entity entity = ClientOperations.getWorld().m_6815_(this.entityId);
            if (entity instanceof AoAAnimatable) {
                AoAAnimatable animatable = (AoAAnimatable)entity;
                animatable.triggerAnim(entity, this.anim);
            }
        });
        context.get().setPacketHandled(true);
    }
}

