/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.misc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.event.GlobalEvents;

public final class OccultBlockRenderer {
    private static final ConcurrentHashMap<Integer, ArrayList<Pair<BlockPos, BlockState>>> occultBlockMap = new ConcurrentHashMap();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, false, RenderLevelLastEvent.class, OccultBlockRenderer::onWorldRender);
    }

    public static void addOccultBlocks(int renderUntil, ArrayList<Pair<BlockPos, BlockState>> blocks) {
        occultBlockMap.put(renderUntil, blocks);
    }

    private static void onWorldRender(RenderLevelLastEvent ev) {
        if (occultBlockMap.isEmpty()) {
            return;
        }
        ArrayList<Integer> expiredBlocks = null;
        for (Map.Entry<Integer, ArrayList<Pair<BlockPos, BlockState>>> entry : occultBlockMap.entrySet()) {
            if (GlobalEvents.tick >= entry.getKey()) {
                if (expiredBlocks == null) {
                    expiredBlocks = new ArrayList<Integer>();
                }
                expiredBlocks.add(entry.getKey());
                continue;
            }
            ArrayList<Pair<BlockPos, BlockState>> invalidBlocks = null;
            Minecraft mc = Minecraft.m_91087_();
            PoseStack matrix = ev.getPoseStack();
            PoseStack cleanMatrix = RenderSystem.m_157191_();
            Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
            Tesselator tess = Tesselator.m_85913_();
            BufferBuilder buff = tess.m_85915_();
            matrix.m_85836_();
            matrix.m_85837_(-cameraPos.m_7096_(), -cameraPos.m_7098_(), -cameraPos.m_7094_());
            cleanMatrix.m_85836_();
            cleanMatrix.m_166854_(matrix.m_85850_().m_85861_());
            RenderSystem.m_69472_();
            RenderSystem.m_69465_();
            RenderSystem.m_69458_((boolean)false);
            RenderSystem.m_69860_((int)1032, (int)6913);
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_69478_();
            for (Pair<BlockPos, BlockState> block : entry.getValue()) {
                if (GlobalEvents.tick % 2 == 1 && mc.f_91074_.f_19853_.m_8055_((BlockPos)block.getFirst()) != block.getSecond()) {
                    if (invalidBlocks == null) {
                        invalidBlocks = new ArrayList<Pair<BlockPos, BlockState>>();
                    }
                    invalidBlocks.add(block);
                    continue;
                }
                Vector4f colour = OccultBlockRenderer.getColourForBlock((BlockState)block.getSecond());
                BlockPos pos = (BlockPos)block.getFirst();
                cleanMatrix.m_85836_();
                cleanMatrix.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                buff.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
                Matrix4f cleanPose = cleanMatrix.m_85850_().m_85861_();
                float red = colour.m_123601_();
                float green = colour.m_123615_();
                float blue = colour.m_123616_();
                float alpha = colour.m_123617_();
                ((BlockState)block.getSecond()).m_60651_((BlockGetter)mc.f_91073_, (BlockPos)block.getFirst(), CollisionContext.m_82750_((Entity)mc.f_91074_)).m_83224_((pMinX, pMinY, pMinZ, pMaxX, pMaxY, pMaxZ) -> {
                    float xLength = (float)(pMaxX - pMinX);
                    float yLength = (float)(pMaxY - pMinY);
                    float zLength = (float)(pMaxZ - pMinZ);
                    float avgLength = Mth.m_14116_((float)(xLength * xLength + yLength * yLength + zLength * zLength));
                    buff.m_85982_(cleanPose, (float)pMinX, (float)pMinY, (float)pMinZ).m_85950_(red, green, blue, alpha).m_85977_(cleanMatrix.m_85850_().m_85864_(), xLength /= avgLength, yLength /= avgLength, zLength /= avgLength).m_5752_();
                    buff.m_85982_(cleanPose, (float)pMaxX, (float)pMaxY, (float)pMaxZ).m_85950_(red, green, blue, alpha).m_85977_(cleanMatrix.m_85850_().m_85864_(), xLength, yLength, zLength).m_5752_();
                });
                tess.m_85914_();
                cleanMatrix.m_85849_();
            }
            RenderSystem.m_69860_((int)1032, (int)6914);
            RenderSystem.m_69461_();
            RenderSystem.m_69482_();
            RenderSystem.m_69458_((boolean)true);
            RenderSystem.m_69493_();
            cleanMatrix.m_85849_();
            matrix.m_85849_();
            if (invalidBlocks == null) continue;
            entry.getValue().removeAll(invalidBlocks);
        }
        if (expiredBlocks != null) {
            for (Integer tick : expiredBlocks) {
                occultBlockMap.remove(tick);
            }
        }
    }

    private static Vector4f getColourForBlock(BlockState block) {
        List tiers = TierSortingRegistry.getSortedTiers();
        float tierCount = tiers.size();
        Vector4f fallback = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
        int i = 0;
        while ((float)i < tierCount) {
            Tier tier = (Tier)tiers.get(i);
            if (TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)block)) {
                return new Vector4f(1.0f - (float)i / tierCount, (float)i / tierCount, 0.0f, 1.0f);
            }
            ++i;
        }
        return fallback;
    }
}

