/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.render.entity.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.tslat.aoa3.advent.AdventOfAscension;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class GeoEntityChargeLayer<T extends Entity>
extends GeoLayerRenderer<T> {
    protected static final ResourceLocation INVULNERABILITY_TEXTURE = AdventOfAscension.id("textures/entity/misc/invulnerability_aura.png");

    public GeoEntityChargeLayer(IGeoRenderer<T> baseRenderer) {
        super(baseRenderer);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int light, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float age, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.getLayerTexture(entity, partialTicks);
        if (texture == null) {
            return;
        }
        float lerpedTicks = (float)((Entity)entity).f_19797_ + partialTicks;
        RenderType renderType = RenderType.m_110436_((ResourceLocation)texture, (float)(this.adjustU(lerpedTicks) % 1.0f), (float)(lerpedTicks * 0.005f % 1.0f));
        GeoModel model = this.getEntityModel().getModel(this.getEntityModel().getModelResource(entity));
        this.getRenderer().render(model, entity, partialTicks, renderType, matrixStack, buffer, buffer.m_6299_(renderType), light, OverlayTexture.f_118083_, 0.5f, 0.5f, 0.5f, 0.5f);
    }

    @Nullable
    protected ResourceLocation getLayerTexture(T entity, float partialTicks) {
        return entity.m_20147_() ? AdventOfAscension.id("textures/entity/misc/invulnerability_aura.png") : null;
    }

    protected float adjustU(float tick) {
        return tick * 0.005f;
    }
}

