/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entity.animal;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.tslat.aoa3.client.model.misc.fullbright.FullbrightCubes;
import net.tslat.aoa3.content.entity.animal.ShinySquidEntity;

public class ShinySquidModel
extends HierarchicalModel<ShinySquidEntity> {
    private final ModelPart[] tentacles = new ModelPart[8];
    private final ModelPart root;

    public ShinySquidModel(ModelPart root) {
        this.root = root;
        Arrays.setAll(this.tentacles, num -> root.m_171324_("tentacle" + num));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition rootPart = meshDefinition.m_171576_();
        FullbrightCubes cubesBuilder = FullbrightCubes.create().texOffs(48, 0).addGlowBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f);
        rootPart.m_171599_("body", (CubeListBuilder)FullbrightCubes.create().texOffs(0, 0).addGlowBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        for (int i = 0; i < 8; ++i) {
            double angle = (double)i * Math.PI / 4.0;
            rootPart.m_171599_("tentacle" + i, (CubeListBuilder)cubesBuilder, PartPose.m_171423_((float)((float)Math.cos(angle) * 5.0f), (float)15.0f, (float)((float)Math.sin(angle) * 5.0f), (float)0.0f, (float)((float)((double)i * Math.PI * -2.0 / 8.0 + 1.5707963267948966)), (float)0.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)32);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(ShinySquidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (ModelPart modelpart : this.tentacles) {
            modelpart.f_104203_ = ageInTicks;
        }
    }
}

