/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.EventPriority;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.util.RenderUtil;

public final class ScreenOverlayRenderer {
    private static final ConcurrentHashMap<ResourceLocation, Integer> overlays = new ConcurrentHashMap();

    public static void init() {
        AdventOfAscension.modEventBus.addListener(EventPriority.NORMAL, false, RegisterGuiOverlaysEvent.class, ev -> ev.registerAboveAll("aoa_mob_overlays", ScreenOverlayRenderer::onOverlayRender));
    }

    public static void addOverlay(ResourceLocation overlay, int duration) {
        overlays.put(overlay, duration);
    }

    public static void tickOverlays() {
        overlays.entrySet().removeIf(entry -> (Integer)entry.getValue() <= 0);
        ((ConcurrentHashMap.KeySetView)overlays.keySet()).spliterator().forEachRemaining(overlay -> overlays.compute((ResourceLocation)overlay, (overlay2, duration) -> duration - 1));
    }

    public static void clearOverlays() {
        overlays.clear();
    }

    private static void onOverlayRender(ForgeGui gui, PoseStack poseStack, float partialTick, int width, int height) {
        if (Minecraft.m_91087_().f_91066_.m_92176_() != CameraType.FIRST_PERSON || overlays.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        Window window = mc.m_91268_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_69465_();
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        for (Map.Entry<ResourceLocation, Integer> entry : overlays.entrySet()) {
            RenderUtil.setRenderingTexture(entry.getKey());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)entry.getValue().intValue() / 50.0f));
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            buffer.m_5483_(0.0, (double)window.m_85446_(), -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)window.m_85445_(), (double)window.m_85446_(), -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            buffer.m_5483_((double)window.m_85445_(), 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            buffer.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
        }
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

