/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client;

import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public final class MusicPlayer {
    private static final HashMap<ResourceLocation, SoundInstance> playingSounds = new HashMap();

    public static void playMusic(ResourceLocation id) {
        SoundEvent soundEvent;
        if (playingSounds.containsKey(id)) {
            if (!Minecraft.m_91087_().m_91106_().m_120403_(playingSounds.get(id))) {
                playingSounds.remove(id);
            } else {
                return;
            }
        }
        if ((soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(id)) == null) {
            Logging.logMessage(Level.DEBUG, "Unable to find sound event with ID: " + id.toString());
            return;
        }
        SimpleSoundInstance sound = SimpleSoundInstance.m_119745_((SoundEvent)soundEvent);
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        playingSounds.put(id, (SoundInstance)sound);
    }

    public static void stopMusic(ResourceLocation id) {
        SoundInstance sound = playingSounds.get(id);
        if (sound != null) {
            SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
            if (soundHandler.m_120403_(sound)) {
                soundHandler.m_120399_(sound);
            }
            playingSounds.remove(id);
        }
    }
}

