/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;

public final class Vec {
    public float x;
    public float y;
    public float z;

    public Vec() {
    }

    public Vec(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vec(Vec v) {
        this(v.x, v.y, v.z);
    }

    public Vec set(Vec v) {
        return this.set(v.x, v.y, v.z);
    }

    public Vec set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Direction getDirectionFromNormal() {
        float x = this.x;
        float y = this.y + 2.0E-4f;
        float z = this.z + 1.0E-4f;
        float ax = Math.abs(x);
        float ay = Math.abs(y);
        float az = Math.abs(z);
        float max = Math.max(Math.max(ax, ay), az);
        if (max == ax) {
            return x > 0.0f ? Direction.EAST : Direction.WEST;
        }
        if (max == az) {
            return z > 0.0f ? Direction.SOUTH : Direction.NORTH;
        }
        if (max == ay) {
            return y > 0.0f ? Direction.UP : Direction.DOWN;
        }
        throw new IllegalStateException("Could not find a direction from the normal, wtf???");
    }

    public Vec add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vec add(Vec vec) {
        return this.add(vec.x, vec.y, vec.z);
    }

    public Vec subtract(float x, float y, float z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
        return this;
    }

    public Vec subtract(float d) {
        return this.subtract(d, d, d);
    }

    public Vec subtract(Vec vec) {
        return this.subtract(vec.x, vec.y, vec.z);
    }

    public Vec multiply(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
        return this;
    }

    public Vec multiply(float d) {
        return this.multiply(d, d, d);
    }

    public Vec multiply(Vec vec) {
        return this.multiply(vec.x, vec.y, vec.z);
    }

    public Vec normalise() {
        float length = Mth.m_14116_((float)(this.x * this.x + this.y * this.y + this.z * this.z));
        if ((double)length < 1.0E-4) {
            return this;
        }
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public static Vec normal(Vec prevVecInFace, Vec vec, Vec nextVecInFace, Vec toUse) {
        float x = vec.x;
        float y = vec.y;
        float z = vec.z;
        return Vec.cross(prevVecInFace.x - x, prevVecInFace.y - y, prevVecInFace.z - z, nextVecInFace.x - x, nextVecInFace.y - y, nextVecInFace.z - z, toUse);
    }

    public static Vec cross(float x0, float y0, float z0, float x1, float y1, float z1, Vec toUse) {
        toUse.x = y0 * z1 - z0 * y1;
        toUse.y = z0 * x1 - x0 * z1;
        toUse.z = x0 * y1 - y0 * x1;
        return toUse;
    }

    public Vec interpolate(float t, Vec v0, Vec v1) {
        this.x = v0.x + t * (v1.x - v0.x);
        this.y = v0.y + t * (v1.y - v0.y);
        this.z = v0.z + t * (v1.z - v0.z);
        return this;
    }

    public BlockPos.MutableBlockPos assignTo(BlockPos.MutableBlockPos pos) {
        return pos.m_122169_((double)this.x, (double)this.y, (double)this.z);
    }
}

