/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.ImmutableList;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import org.apache.logging.log4j.LogManager;

public class ModUtil {
    public static final BlockPos VEC_ZERO = new BlockPos(0, 0, 0);
    public static final BlockPos VEC_ONE = new BlockPos(1, 1, 1);
    public static final BlockPos VEC_TWO = new BlockPos(2, 2, 2);
    public static final BlockPos CHUNK_SIZE = new BlockPos(16, 16, 16);
    public static final Direction[] DIRECTIONS = Direction.values();
    public static final float FULLY_SMOOTHABLE = 1.0f;
    public static final float NOT_SMOOTHABLE = -1.0f;

    public static ImmutableList<BlockState> getStates(Block block) {
        return block.m_49965_().m_61056_();
    }

    public static int length(BlockPos size) {
        return size.m_123341_() * size.m_123342_() * size.m_123343_();
    }

    public static void warnPlayer(@Nullable Player player, String translationKey, Object ... formatArgs) {
        if (player != null) {
            player.m_213846_((Component)Component.m_237110_((String)translationKey, (Object[])formatArgs).m_130940_(ChatFormatting.RED));
        } else {
            LogManager.getLogger((String)"NoCubes notification fallback").warn(I18n.m_118938_((String)translationKey, (Object[])formatArgs));
        }
    }

    public static float getBlockDensity(Predicate<BlockState> isSmoothable, BlockState state) {
        return ModUtil.getBlockDensity(isSmoothable.test(state), state);
    }

    public static float getBlockDensity(boolean shouldSmooth, BlockState state) {
        if (!shouldSmooth) {
            return -1.0f;
        }
        if (ModUtil.isSnowLayer(state)) {
            return ModUtil.mapSnowHeight((Integer)state.m_61143_((Property)SnowLayerBlock.f_56581_));
        }
        return 1.0f;
    }

    private static float mapSnowHeight(int value) {
        return -1.0f + (float)(value - 1) * 0.25f;
    }

    public static boolean isSnowLayer(BlockState state) {
        return state.m_61138_((Property)SnowLayerBlock.f_56581_);
    }

    public static boolean isShortPlant(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof BushBlock && !(block instanceof DoublePlantBlock) && !(block instanceof CropBlock) && !(block instanceof StemBlock);
    }

    public static boolean isPlant(BlockState state) {
        Material material = state.m_60767_();
        return material == Material.f_76300_ || material == Material.f_76301_ || material == Material.f_76302_ || material == Material.f_76303_ || material == Material.f_76304_ || material == Material.f_76270_ || material == Material.f_76271_ || material == Material.f_76285_;
    }

    public static int get3dIndexInto1dArray(int x, int y, int z, int xSize, int ySize) {
        return xSize * ySize * z + xSize * y + x;
    }

    public static FluidState getExtendedFluidState(Level world, BlockPos pos) {
        int extendRange = NoCubesConfig.Server.extendFluidsRange;
        assert (extendRange > 0);
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int chunkX = x >> 4;
        int z = pos.m_123343_();
        int chunkZ = z >> 4;
        LevelChunk chunk = world.m_6325_(chunkX, chunkZ);
        FluidState fluid = chunk.m_62814_(x, y, z);
        if (!fluid.m_76178_() || !NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)chunk.m_8055_(pos))) {
            return fluid;
        }
        fluid = chunk.m_62814_(x, y + 1, z);
        if (fluid.m_76170_()) {
            return fluid;
        }
        for (int extendZ = z - extendRange; extendZ <= z + extendRange; ++extendZ) {
            for (int extendX = x - extendRange; extendX <= x + extendRange; ++extendX) {
                if (extendZ == z && extendX == x) continue;
                if (chunkX != extendZ >> 4 || chunkZ != extendX >> 4) {
                    chunkZ = extendZ >> 4;
                    chunkX = extendX >> 4;
                    chunk = world.m_6325_(chunkX, chunkZ);
                }
                if (!(fluid = chunk.m_62814_(extendX, y, extendZ)).m_76170_()) continue;
                return fluid;
            }
        }
        return Fluids.f_76191_.m_76145_();
    }
}

