/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface BlockStateConverter {
    public static final BlockStateArgument PARSER = new BlockStateArgument(new CommandBuildContext((RegistryAccess)RegistryAccess.f_123049_.get()));

    public static BlockState fromId(int id) {
        BlockState state = (BlockState)Block.f_49791_.m_7942_(id);
        if (state == null) {
            throw new IllegalStateException("Unknown blockstate id" + id);
        }
        return state;
    }

    public static int toId(BlockState state) {
        int id = Block.f_49791_.m_7447_((Object)state);
        if (id == -1) {
            throw new IllegalStateException("Unknown blockstate " + state);
        }
        return id;
    }

    public static BlockState fromStringOrNull(String string) {
        try {
            return PARSER.parse(new StringReader(string)).m_114669_();
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static String toString(BlockState state) {
        String block = Registry.f_122824_.m_7981_((Object)state.m_60734_()).toString();
        ImmutableMap values = state.m_61148_();
        if (values.isEmpty()) {
            return block;
        }
        return values.entrySet().stream().map(e -> ((Property)e.getKey()).m_61708_() + "=" + Util.m_137453_((Property)((Property)e.getKey()), e.getValue())).collect(Collectors.joining(",", block + "[", "]"));
    }

    public static void writeBlockStatesTo(FriendlyByteBuf buffer, BlockState[] states) {
        int[] ids = Arrays.stream(states).mapToInt(BlockStateConverter::toId).toArray();
        buffer.m_130089_(ids);
    }

    public static BlockState[] readBlockStatesFrom(FriendlyByteBuf buffer) {
        return (BlockState[])Arrays.stream(buffer.m_130100_()).mapToObj(BlockStateConverter::fromId).toArray(BlockState[]::new);
    }
}

