/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.util;

import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class Area
implements AutoCloseable {
    private static final ThreadLocalArrayCache<BlockState[]> BLOCKS_CACHE = new ThreadLocalArrayCache<BlockState[]>(BlockState[]::new, array -> ((BlockState[])array).length);
    public final BlockPos start;
    public final BlockPos size;
    private final BlockGetter world;
    private BlockState[] blocks;

    public Area(BlockGetter world, BlockPos startInclusive, BlockPos size) {
        this.world = world;
        this.start = startInclusive.m_7949_();
        this.size = size.m_7949_();
    }

    public Area(BlockGetter world, BlockPos startInclusive, BlockPos size, Mesher mesher) {
        this.world = world;
        Vec3i negativeExtension = mesher.getNegativeAreaExtension();
        Vec3i positiveExtension = mesher.getPositiveAreaExtension();
        this.start = startInclusive.m_121996_(negativeExtension).m_7949_();
        this.size = new BlockPos(size.m_123341_() + negativeExtension.m_123341_() + positiveExtension.m_123341_(), size.m_123342_() + negativeExtension.m_123342_() + positiveExtension.m_123342_(), size.m_123343_() + negativeExtension.m_123343_() + positiveExtension.m_123343_());
    }

    public BlockState[] getAndCacheBlocks() {
        if (this.blocks == null) {
            this.blocks = BLOCKS_CACHE.takeArray(this.numBlocks());
            BlockState[] array = this.blocks;
            BlockPos start = this.start;
            int startX = start.m_123341_();
            int startY = start.m_123342_();
            int startZ = start.m_123343_();
            BlockPos size = this.size;
            int endX = startX + size.m_123341_();
            int endY = startY + size.m_123342_();
            int endZ = startZ + size.m_123343_();
            BlockGetter world = this.world;
            if (world instanceof LevelReader) {
                BlockPos endInclusive = new BlockPos(endX - 1, endY - 1, endZ - 1);
                Area.traverse((Vec3i)start, (Vec3i)endInclusive, new BlockPos.MutableBlockPos(), (LevelReader)world, (state, pos, zyxIndex) -> {
                    array[zyxIndex] = state;
                    return true;
                });
            } else {
                BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
                int zyxIndex2 = 0;
                for (int z = startZ; z < endZ; ++z) {
                    for (int y = startY; y < endY; ++y) {
                        int x = startX;
                        while (x < endX) {
                            array[zyxIndex2] = world.m_8055_((BlockPos)pos2.m_122178_(x, y, z));
                            ++x;
                            ++zyxIndex2;
                        }
                    }
                }
            }
        }
        return this.blocks;
    }

    public int numBlocks() {
        return ModUtil.length(this.size);
    }

    public int index(BlockPos relativePos) {
        int index = this.indexIfInsideCache(relativePos);
        if (index == -1) {
            throw new IndexOutOfBoundsException("relativePos was " + relativePos + " but should have been within " + ModUtil.VEC_ZERO + " and " + this.size);
        }
        return index;
    }

    public int indexIfInsideCache(BlockPos relativePos) {
        return this.indexIfInsideCache(relativePos.m_123341_(), relativePos.m_123342_(), relativePos.m_123343_());
    }

    public int indexIfInsideCache(int relativeX, int relativeY, int relativeZ) {
        BlockPos size = this.size;
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        if (relativeX < 0 || relativeX >= sizeX || relativeY < 0 || relativeY >= sizeY || relativeZ < 0 || relativeZ >= size.m_123343_()) {
            return -1;
        }
        return ModUtil.get3dIndexInto1dArray(relativeX, relativeY, relativeZ, sizeX, sizeY);
    }

    @Override
    public void close() {
    }

    public BlockState getBlockState(BlockPos.MutableBlockPos relativePos) {
        int index = this.indexIfInsideCache((BlockPos)relativePos);
        if (index == -1) {
            int x = relativePos.m_123341_();
            int y = relativePos.m_123342_();
            int z = relativePos.m_123343_();
            BlockState state = this.world.m_8055_((BlockPos)relativePos.m_122193_((Vec3i)this.start));
            relativePos.m_122178_(x, y, z);
            return state;
        }
        return this.getAndCacheBlocks()[index];
    }

    public static void traverse(Vec3i startInclusive, Vec3i endInclusive, BlockPos.MutableBlockPos currentPosition, LevelReader world, Traverser func) {
        Area.traverse(startInclusive.m_123341_(), startInclusive.m_123342_(), startInclusive.m_123343_(), endInclusive.m_123341_(), endInclusive.m_123342_(), endInclusive.m_123343_(), currentPosition, world, func);
    }

    public static void traverse(int startXInclusive, int startYInclusive, int startZInclusive, int endXInclusive, int endYInclusive, int endZInclusive, BlockPos.MutableBlockPos currentPosition, LevelReader world, Traverser func) {
        Area.traverse(startXInclusive, startYInclusive, startZInclusive, endXInclusive, endYInclusive, endZInclusive, currentPosition, (int x, int z) -> world.m_6522_(x, z, ChunkStatus.f_62314_, false), func);
    }

    public static void traverse(int startXInclusive, int startYInclusive, int startZInclusive, int endXInclusive, int endYInclusive, int endZInclusive, BlockPos.MutableBlockPos currentPosition, ChunkGetter world, Traverser func) {
        BlockState air = Blocks.f_50016_.m_49966_();
        int endXPlus1 = endXInclusive + 1;
        int endYPlus1 = endYInclusive + 1;
        int endZPlus1 = endZInclusive + 1;
        int maxX = endXInclusive + 16 & 0xFFFFFFF0;
        int maxY = endYInclusive + 16 & 0xFFFFFFF0;
        int maxZ = endZInclusive + 16 & 0xFFFFFFF0;
        int width = endXPlus1 - startXInclusive;
        int height = endYPlus1 - startYInclusive;
        int widthMulHeight = width * height;
        for (int blockChunkZ = startZInclusive; blockChunkZ < maxZ; blockChunkZ += 16) {
            int maskedBlockChunkZ = blockChunkZ & 0xFFFFFFF0;
            int maskedNextBlockChunkZ = blockChunkZ + 16 & 0xFFFFFFF0;
            for (int blockChunkX = startXInclusive; blockChunkX < maxX; blockChunkX += 16) {
                int maskedBlockChunkX = blockChunkX & 0xFFFFFFF0;
                int maskedNextBlockChunkX = blockChunkX + 16 & 0xFFFFFFF0;
                int chunkX = blockChunkX >> 4;
                int chunkZ = blockChunkZ >> 4;
                ChunkAccess chunk = world.getChunk(chunkX, chunkZ);
                LevelChunkSection[] sections = chunk == null ? null : chunk.m_7103_();
                int chunkMinSection = chunk != null ? chunk.m_151560_() : 0;
                for (int blockChunkY = startYInclusive; blockChunkY < maxY; blockChunkY += 16) {
                    int maskedBlockChunkY = blockChunkY & 0xFFFFFFF0;
                    int maskedNextBlockChunkY = blockChunkY + 16 & 0xFFFFFFF0;
                    int sectionIndex = (blockChunkY >> 4) - chunkMinSection;
                    LevelChunkSection section = sections == null || sectionIndex < 0 || sectionIndex >= sections.length ? null : sections[sectionIndex];
                    int sectionMinX = Math.max(maskedBlockChunkX, startXInclusive);
                    int sectionMinY = Math.max(maskedBlockChunkY, startYInclusive);
                    int sectionMinZ = Math.max(maskedBlockChunkZ, startZInclusive);
                    int sectionMaxX = Math.min(maskedNextBlockChunkX, endXPlus1);
                    int sectionMaxY = Math.min(maskedNextBlockChunkY, endYPlus1);
                    int sectionMaxZ = Math.min(maskedNextBlockChunkZ, endZPlus1);
                    for (int y = sectionMinY; y < sectionMaxY; ++y) {
                        int maskedY = y & 0xF;
                        for (int z = sectionMinZ; z < sectionMaxZ; ++z) {
                            int maskedZ = z & 0xF;
                            for (int x = sectionMinX; x < sectionMaxX; ++x) {
                                BlockState state = section == null ? air : section.m_62982_(x & 0xF, maskedY, maskedZ);
                                currentPosition.m_122178_(x, y, z);
                                int zyxIndex = (z - startZInclusive) * widthMulHeight + (y - startYInclusive) * width + (x - startXInclusive);
                                if (func.accept(state, currentPosition, zyxIndex)) continue;
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    public static interface Traverser {
        public boolean accept(BlockState var1, BlockPos.MutableBlockPos var2, int var3);
    }

    public static interface ChunkGetter {
        @Nullable
        public ChunkAccess getChunk(int var1, int var2);
    }
}

