/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.RenderHelper;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public record S2CUpdateSmoothable(boolean newValue, BlockState[] states) {
    public static void encode(S2CUpdateSmoothable msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.newValue);
        BlockStateConverter.writeBlockStatesTo(buffer, msg.states);
    }

    public static S2CUpdateSmoothable decode(FriendlyByteBuf buffer) {
        return new S2CUpdateSmoothable(buffer.readBoolean(), BlockStateConverter.readBlockStatesFrom(buffer));
    }

    public static void handle(S2CUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> {
            NoCubes.smoothableHandler.setSmoothable(msg.newValue, (BlockBehaviour.BlockStateBase[])msg.states);
            RenderHelper.reloadAllChunks("the server told us that the smoothness of some states changed", new Object[0]);
        });
        ctx.setPacketHandled(true);
    }
}

