/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.network.C2SRequestUpdateSmoothable;
import io.github.cadiboo.nocubes.network.S2CUpdateServerConfig;
import io.github.cadiboo.nocubes.network.S2CUpdateSmoothable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NoCubesNetwork {
    private static final Logger LOG = LogManager.getLogger();
    public static final int REQUIRED_PERMISSION_LEVEL = 2;
    private static final String NETWORK_PROTOCOL_VERSION = "2";
    public static boolean currentServerHasNoCubes = false;
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("nocubes", "main"), () -> "2", serverVersion -> {
        if (NetworkRegistry.ABSENT.equals(serverVersion) || NetworkRegistry.ACCEPTVANILLA.equals(serverVersion)) {
            currentServerHasNoCubes = false;
            return true;
        }
        currentServerHasNoCubes = true;
        return NETWORK_PROTOCOL_VERSION.equals(serverVersion);
    }, "2"::equals);

    public static void register() {
        int networkId = 0;
        NoCubesNetwork.register(networkId, C2SRequestUpdateSmoothable.class, C2SRequestUpdateSmoothable::encode, C2SRequestUpdateSmoothable::decode, C2SRequestUpdateSmoothable::handle);
        NoCubesNetwork.register(++networkId, S2CUpdateSmoothable.class, S2CUpdateSmoothable::encode, S2CUpdateSmoothable::decode, S2CUpdateSmoothable::handle);
        NoCubesNetwork.register(++networkId, S2CUpdateServerConfig.class, S2CUpdateServerConfig::encode, S2CUpdateServerConfig::decode, S2CUpdateServerConfig::handle);
    }

    static <MSG> void register(int index, Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
        CHANNEL.registerMessage(index, messageType, (msg, buffer) -> {
            LOG.debug("Encoding {}", (Object)messageType.getSimpleName());
            encoder.accept((Object)msg, (FriendlyByteBuf)buffer);
        }, buffer -> {
            LOG.debug("Decoding {}", (Object)messageType.getSimpleName());
            return decoder.apply((FriendlyByteBuf)buffer);
        }, (msg, ctx) -> {
            LOG.debug("Handling {}", (Object)messageType.getSimpleName());
            handler.accept((Object)msg, (Supplier<NetworkEvent.Context>)ctx);
        });
    }
}

