/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.network;

import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateSmoothable;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SRequestUpdateSmoothable(boolean newValue, BlockState[] states) {
    public static void encode(C2SRequestUpdateSmoothable msg, FriendlyByteBuf buffer) {
        buffer.writeBoolean(msg.newValue);
        BlockStateConverter.writeBlockStatesTo(buffer, msg.states);
    }

    public static C2SRequestUpdateSmoothable decode(FriendlyByteBuf buffer) {
        return new C2SRequestUpdateSmoothable(buffer.readBoolean(), BlockStateConverter.readBlockStatesFrom(buffer));
    }

    public static void handle(C2SRequestUpdateSmoothable msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ServerPlayer sender = Objects.requireNonNull(ctx.getSender(), "Command sender was null");
        if (C2SRequestUpdateSmoothable.checkPermissionAndNotifyIfUnauthorised((Player)sender, sender.f_8924_)) {
            boolean newValue = msg.newValue;
            BlockState[] statesToUpdate = (BlockState[])Arrays.stream(msg.states).filter(s -> NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)s) != newValue).toArray(BlockState[]::new);
            if (statesToUpdate.length == 0) {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CUpdateSmoothable(newValue, msg.states));
            } else {
                ctx.enqueueWork(() -> NoCubesConfig.Server.updateSmoothable(newValue, statesToUpdate));
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CUpdateSmoothable(newValue, statesToUpdate));
            }
        }
        ctx.setPacketHandled(true);
    }

    public static boolean checkPermissionAndNotifyIfUnauthorised(Player player, @Nullable MinecraftServer connectedToServer) {
        if (connectedToServer != null && connectedToServer.m_7779_(player.m_36316_())) {
            return true;
        }
        if (player.m_20310_(2)) {
            return true;
        }
        ModUtil.warnPlayer(player, "nocubes.command.changeSmoothableNoPermission", new Object[0]);
        return false;
    }
}

