/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mixin;

import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.hooks.Hooks;
import io.github.cadiboo.nocubes.hooks.INoCubesBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseMixin
implements INoCubesBlockState {
    public boolean nocubes_isSmoothable;

    @Shadow
    protected abstract BlockState m_7160_();

    @Shadow
    public abstract Block m_60734_();

    @Override
    public void setTerrainSmoothable(boolean value) {
        this.nocubes_isSmoothable = value;
    }

    @Override
    public boolean isTerrainSmoothable() {
        return this.nocubes_isSmoothable;
    }

    @Inject(method={"canOcclude()Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void nocubes_canOcclude(CallbackInfoReturnable<Boolean> ci) {
        if (Hooks.shouldCancelOcclusion((BlockBehaviour.BlockStateBase)this)) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getVisualShape"}, at={@At(value="HEAD")}, cancellable=true)
    public void nocubes_getVisualShape(BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        BlockState state = this.m_7160_();
        VoxelShape visualShape = this.m_60734_().m_5909_(state, level, pos, context);
        if (visualShape.m_83281_() || !Hooks.renderingEnabledFor((BlockBehaviour.BlockStateBase)state)) {
            cir.setReturnValue((Object)visualShape);
        } else {
            cir.setReturnValue((Object)state.m_60742_(level, pos, context));
        }
    }

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    public void nocubes_getCollisionShape(BlockGetter level, BlockPos pos, CallbackInfoReturnable<VoxelShape> cir) {
        BlockStateBaseMixin.nocubes_collisionShapeHelper(this.m_7160_(), level, pos, CollisionContext.m_82749_(), cir);
    }

    @Inject(method={"getCollisionShape(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="HEAD")}, cancellable=true)
    public void nocubes_getCollisionShape(BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        BlockStateBaseMixin.nocubes_collisionShapeHelper(this.m_7160_(), level, pos, context, cir);
    }

    @Unique
    private static void nocubes_collisionShapeHelper(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context, CallbackInfoReturnable<VoxelShape> cir) {
        if (Hooks.collisionsEnabledFor((BlockBehaviour.BlockStateBase)state)) {
            cir.setReturnValue((Object)CollisionHandler.getCollisionShape(state, level, pos, context));
        }
    }

    @Inject(method={"hasLargeCollisionShape"}, at={@At(value="HEAD")}, cancellable=true)
    public void nocubes_hasLargeCollisionShape(CallbackInfoReturnable<Boolean> cir) {
        if (Hooks.collisionsEnabledFor((BlockBehaviour.BlockStateBase)this.m_7160_())) {
            cir.setReturnValue((Object)true);
        }
    }
}

