/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;

public interface TestData {
    public static final TestMesh SPHERE = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.25f), new Vec(-1.0f, 1.0f, 0.25f), new Vec(-1.0f, 1.0f, 0.25f), (x, y, z) -> x * x + y * y + z * z - 1.0f);
    public static final TestMesh TORUS = TestData.makeVolume(new Vec(-2.0f, 2.0f, 0.2f), new Vec(-2.0f, 2.0f, 0.2f), new Vec(-1.0f, 1.0f, 0.2f), (x, y, z) -> (float)Math.pow(1.0 - Math.sqrt(x * x + y * y), 2.0) + z * z - 0.25f);
    public static final TestMesh DONUT = TestData.makeVolume(new Vec(-2.0f, 2.0f, 0.2f), new Vec(-1.0f, 1.0f, 0.2f), new Vec(-2.0f, 2.0f, 0.2f), (x, y, z) -> (float)Math.pow(1.0 - Math.sqrt(x * x + z * z), 2.0) + y * y - 0.25f);
    public static final TestMesh BIG_SPHERE = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), (x, y, z) -> x * x + y * y + z * z - 1.0f);
    public static final TestMesh HYPER_ELLIPTIC = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), (x, y, z) -> (float)(Math.pow(Math.pow(x, 6.0) + Math.pow(y, 6.0) + Math.pow(z, 6.0), 0.16666666666666666) - 1.0));
    public static final TestMesh NODAL_CUBIC = TestData.makeVolume(new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), (x, y, z) -> x * y + y * z + z * x + x * y * z);
    public static final TestMesh GOURSATS_SURFACE = TestData.makeVolume(new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), (x, y, z) -> (float)(Math.pow(x, 4.0) + Math.pow(y, 4.0) + Math.pow(z, 4.0) - 1.5 * (double)(x * x + y * y + z * z) + 1.0));
    public static final TestMesh HEART = TestData.makeVolume(new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), new Vec(-2.0f, 2.0f, 0.05f), (x, y, z) -> {
        y = (float)((double)y * 1.5);
        z = (float)((double)z * 1.5);
        return (float)(Math.pow(2.0f * x * x + y * y + 2.0f * z * z - 1.0f, 3.0) - 0.1 * (double)z * (double)z * (double)y * (double)y * (double)y - (double)(y * y * y * x * x));
    });
    public static final TestMesh NORDSTRANDS_WEIRD_SURFACE = TestData.makeVolume(new Vec(-0.8f, 0.8f, 0.01f), new Vec(-0.8f, 0.8f, 0.01f), new Vec(-0.8f, 0.8f, 0.01f), (x, y, z) -> (float)(25.0 * (Math.pow(x, 3.0) * (double)(y + z) + Math.pow(y, 3.0) * (double)(x + z) + Math.pow(z, 3.0) * (double)(x + y)) + (double)(50.0f * (x * x * y * y + x * x * z * z + y * y * z * z)) - (double)(125.0f * (x * x * y * z + y * y * x * z + z * z * x * y)) + (double)(60.0f * x * y * z) - (double)(4.0f * (x * y + x * z + y * z))));
    public static final float PI = (float)Math.PI;
    public static final TestMesh SINE_WAVES = TestData.makeVolume(new Vec((float)Math.PI * -2, (float)Math.PI * 2, 0.3926991f), new Vec((float)Math.PI * -2, (float)Math.PI * 2, 0.3926991f), new Vec((float)Math.PI * -2, (float)Math.PI * 2, 0.3926991f), (x, y, z) -> (float)(Math.sin(x) + Math.sin(y) + Math.sin(z)));
    public static final TestMesh PERLIN_NOISE = TestData.makeVolume(new Vec(-5.0f, 5.0f, 0.25f), new Vec(-5.0f, 5.0f, 0.25f), new Vec(-5.0f, 5.0f, 0.25f), (x, y, z) -> PerlinNoise.noise(x, y, z) - 0.5f);
    public static final TestMesh ASTEROID = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.08f), new Vec(-1.0f, 1.0f, 0.08f), new Vec(-1.0f, 1.0f, 0.08f), (x, y, z) -> x * x + y * y + z * z - PerlinNoise.noise(x * 2.0f, y * 2.0f, z * 2.0f));
    public static final TestMesh TERRAIN = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), new Vec(-1.0f, 1.0f, 0.05f), (x, y, z) -> y + PerlinNoise.noise(x * 2.0f + 5.0f, y * 2.0f + 3.0f, z * 2.0f + 0.6f));
    public static final TestMesh PYRAMID = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), (x, y, z) -> {
        float ROOT_3 = (float)Math.sqrt(3.0);
        float[][] planes = new float[][]{{-ROOT_3, ROOT_3, -ROOT_3}, {-ROOT_3, ROOT_3, ROOT_3}, {ROOT_3, ROOT_3, -ROOT_3}, {ROOT_3, ROOT_3, ROOT_3}};
        float[][] planeOffsets = new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f}};
        return TestData.distanceFromConvexPlanes(planes, planeOffsets, x, y, z);
    });
    public static final TestMesh HALF_OFFSET_PYRAMID = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), (x, y, z) -> {
        float ROOT_3 = (float)Math.sqrt(3.0);
        float[][] planes = new float[][]{{-ROOT_3, ROOT_3, -ROOT_3}, {-ROOT_3, ROOT_3, ROOT_3}, {ROOT_3, ROOT_3, -ROOT_3}, {ROOT_3, ROOT_3, ROOT_3}};
        float[][] planeOffsets = new float[][]{{0.0625f, 0.0625f, 0.0625f}, {0.0625f, 0.0625f, 0.0625f}, {0.0625f, 0.0625f, 0.0625f}, {0.0625f, 0.0625f, 0.0625f}};
        return TestData.distanceFromConvexPlanes(planes, planeOffsets, x, y, z);
    });
    public static final TestMesh TETRAHEDRON = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), (x, y, z) -> {
        float INV_ROOT_3 = (float)(Math.sqrt(3.0) / 3.0);
        float[][] planes = new float[][]{{INV_ROOT_3, INV_ROOT_3, INV_ROOT_3}, {-INV_ROOT_3, -INV_ROOT_3, INV_ROOT_3}, {INV_ROOT_3, -INV_ROOT_3, -INV_ROOT_3}, {-INV_ROOT_3, INV_ROOT_3, -INV_ROOT_3}};
        float[][] planeOffsets = new float[][]{{0.25f, 0.25f, 0.25f}, {-0.25f, -0.25f, 0.25f}, {0.25f, -0.25f, -0.25f}, {-0.25f, 0.25f, -0.25f}};
        return TestData.distanceFromConvexPlanes(planes, planeOffsets, x, y, z);
    });
    public static final TestMesh HALF_OFFSET_TETRAHEDRON = TestData.makeVolume(new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), new Vec(-1.0f, 1.0f, 0.125f), (x, y, z) -> {
        float INV_ROOT_3 = (float)(Math.sqrt(3.0) / 3.0);
        float[][] planes = new float[][]{{INV_ROOT_3, INV_ROOT_3, INV_ROOT_3}, {-INV_ROOT_3, -INV_ROOT_3, INV_ROOT_3}, {INV_ROOT_3, -INV_ROOT_3, -INV_ROOT_3}, {-INV_ROOT_3, INV_ROOT_3, -INV_ROOT_3}};
        float[][] planeOffsets = new float[][]{{0.3125f, 0.3125f, 0.3125f}, {-0.3125f, -0.3125f, 0.3125f}, {0.3125f, -0.3125f, -0.3125f}, {-0.3125f, 0.3125f, -0.3125f}};
        return TestData.distanceFromConvexPlanes(planes, planeOffsets, x, y, z);
    });

    public static TestMesh makeVolume(Vec dimX, Vec dimY, Vec dimZ, DistanceFunction func) {
        return new TestMesh(dimX, dimY, dimZ, func);
    }

    public static float distanceFromConvexPlanes(float[][] planes, float[][] planeOffsets, float x, float y, float z) {
        float maxDistance = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < planes.length; ++i) {
            float x_ = x - planeOffsets[i][0];
            float y_ = y - planeOffsets[i][1];
            float z_ = z - planeOffsets[i][2];
            float dotProduct = planes[i][0] * x_ + planes[i][1] * y_ + planes[i][2] * z_;
            maxDistance = Math.max(maxDistance, dotProduct);
        }
        return maxDistance;
    }

    public static final class TestMesh {
        private final Vec dimX;
        private final Vec dimY;
        private final Vec dimZ;
        private final DistanceFunction distanceFunction;
        public final BlockPos dimensions;

        private TestMesh(Vec dimX, Vec dimY, Vec dimZ, DistanceFunction distanceFunction) {
            this.dimX = dimX;
            this.dimY = dimY;
            this.dimZ = dimZ;
            this.distanceFunction = distanceFunction;
            this.dimensions = new BlockPos(TestMesh.getAxisSize(dimX), TestMesh.getAxisSize(dimY), TestMesh.getAxisSize(dimZ));
        }

        public float[] generateDistanceField(int posX, int posY, int posZ) {
            PerlinNoise.setOffset(posX, posY, posZ);
            float[] distanceField = new float[ModUtil.length(this.dimensions)];
            int index = 0;
            float k = 0.0f;
            float z = this.dimZ.x - this.dimZ.z;
            while (k < (float)this.dimensions.m_123343_()) {
                float j = 0.0f;
                float y = this.dimY.x - this.dimY.z;
                while (j < (float)this.dimensions.m_123342_()) {
                    float i = 0.0f;
                    float x = this.dimX.x - this.dimX.z;
                    while (i < (float)this.dimensions.m_123341_()) {
                        distanceField[index] = this.distanceFunction.apply(x, y, z);
                        i += 1.0f;
                        x += this.dimX.z;
                        ++index;
                    }
                    j += 1.0f;
                    y += this.dimY.z;
                }
                k += 1.0f;
                z += this.dimZ.z;
            }
            return distanceField;
        }

        private static int getAxisSize(Vec point) {
            return 2 + (int)Math.ceil((point.y - point.x) / point.z);
        }
    }

    public static interface DistanceFunction {
        public float apply(float var1, float var2, float var3);
    }

    public static final class PerlinNoise {
        private static final ThreadLocal<NoiseConfig> CONFIG = ThreadLocal.withInitial(NoiseConfig::new);

        public static void setOffset(int posX, int posY, int posZ) {
            NoiseConfig config = CONFIG.get();
            config.offsetX = posX;
            config.offsetY = posY;
            config.offsetZ = posZ;
        }

        public static float noise(float x, float y, float z) {
            NoiseConfig config = CONFIG.get();
            return (float)config.generator.m_75467_((double)(x += (float)config.offsetX), (double)(y += (float)config.offsetY), (double)(z += (float)config.offsetZ)) / 32.0f;
        }

        static final class NoiseConfig {
            int offsetX;
            int offsetY;
            int offsetZ;
            SimplexNoise generator = new SimplexNoise((RandomSource)new SingleThreadedRandomSource(0L));

            NoiseConfig() {
            }
        }
    }
}

