/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.collision.ShapeConsumer;
import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.mesh.SDFMesher;
import io.github.cadiboo.nocubes.mesh.TestData;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public class SurfaceNets
extends SDFMesher {
    public SurfaceNets(boolean smoothness2x) {
        super(smoothness2x);
    }

    @Override
    public Vec3i getPositiveAreaExtension() {
        return ModUtil.VEC_ONE;
    }

    @Override
    public Vec3i getNegativeAreaExtension() {
        return this.smoothness2x ? ModUtil.VEC_TWO : ModUtil.VEC_ONE;
    }

    @Override
    public void generateCollisionsInternal(Area area, Predicate<BlockState> isSmoothable, ShapeConsumer action) {
        Face vertexNormals = new Face();
        Vec faceNormal = new Vec();
        Vec centre = new Vec();
        this.generateOrThrow(area, isSmoothable, (x, y, z) -> ShapeConsumer.acceptFullCube(x, y, z, action), (pos, face) -> {
            face.assignAverageTo(centre);
            face.assignNormalTo(vertexNormals);
            vertexNormals.assignAverageTo(faceNormal);
            return CollisionHandler.generateShapes(centre, faceNormal, action, face);
        });
    }

    @Override
    public void generateGeometryInternal(Area area, Predicate<BlockState> isSmoothable, Mesher.FaceAction action) {
        this.generateOrThrow(area, isSmoothable, SDFMesher.FullCellAction.IGNORE, action);
    }

    private void generateOrThrow(Area area, Predicate<BlockState> isSmoothable, SDFMesher.FullCellAction fullCellAction, Mesher.FaceAction action) {
        TestData.TestMesh testMesh = null;
        boolean smoother = this.smoothness2x;
        float[] distanceField = SurfaceNets.generateDistanceField(area, isSmoothable, smoother, testMesh);
        BlockPos dims = SurfaceNets.getDimensions(area, smoother, testMesh);
        float offset = smoother ? 1.0f : 0.5f;
        SurfaceNets.generateOrThrow2(distanceField, dims, (x, y, z) -> fullCellAction.apply(x + (double)offset, y + (double)offset, z + (double)offset), (pos, face) -> action.apply(pos, face.add(offset)));
    }

    private static void generateOrThrow2(float[] distanceField, BlockPos dims, SDFMesher.FullCellAction fullCellAction, Mesher.FaceAction action) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        Face face = new Face();
        int n = 0;
        int[] axisMultipliers = new int[]{1, dims.m_123341_() + 1, (dims.m_123341_() + 1) * (dims.m_123342_() + 1)};
        float[] cornerDistances = new float[8];
        int buf_no = 1;
        Vec[] verticesBuffer = new Vec[axisMultipliers[2] * 2];
        float[] vertexUntilIFigureOutTheInterpolationAndIntersection = new float[]{0.0f, 0.0f, 0.0f};
        int z = 0;
        while (z < dims.m_123343_() - 1) {
            int bufferPointer = 1 + (dims.m_123341_() + 1) * (1 + buf_no * (dims.m_123342_() + 1));
            int y = 0;
            while (y < dims.m_123342_() - 1) {
                int x = 0;
                while (x < dims.m_123341_() - 1) {
                    int mask = 0;
                    int corner = 0;
                    int cornerIndex = n;
                    int cornerZ = 0;
                    while (cornerZ < 2) {
                        int cornerY = 0;
                        while (cornerY < 2) {
                            int cornerX = 0;
                            while (cornerX < 2) {
                                float signedDistance;
                                cornerDistances[corner] = signedDistance = distanceField[cornerIndex];
                                boolean insideIsosurface = signedDistance < 0.0f;
                                mask = (short)(mask | (insideIsosurface ? 1 << corner : 0));
                                cornerX = (byte)(cornerX + 1);
                                corner = (short)(corner + 1);
                                ++cornerIndex;
                            }
                            ++cornerY;
                            cornerIndex += dims.m_123341_() - 2;
                        }
                        ++cornerZ;
                        cornerIndex += dims.m_123341_() * (dims.m_123342_() - 2);
                    }
                    if (mask == 255 && !fullCellAction.apply(x, y, z)) {
                        return;
                    }
                    if (mask != 0 && mask != 255) {
                        int edge_mask = Lookup.EDGE_TABLE[mask];
                        vertexUntilIFigureOutTheInterpolationAndIntersection[2] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[1] = 0.0f;
                        vertexUntilIFigureOutTheInterpolationAndIntersection[0] = 0.0f;
                        int edgeCrossings = 0;
                        for (int edge = 0; edge < 12; ++edge) {
                            if ((edge_mask & 1 << edge) == 0) continue;
                            ++edgeCrossings;
                            int edgeStart = Lookup.CUBE_EDGES[edge << 1];
                            float edgeStartValue = cornerDistances[edgeStart];
                            int edgeEnd = Lookup.CUBE_EDGES[(edge << 1) + 1];
                            float edgeEndValue = cornerDistances[edgeEnd];
                            float t = edgeStartValue - edgeEndValue;
                            if (Math.abs(t) <= 1.0E-8f) continue;
                            t = edgeStartValue / t;
                            int axis = 0;
                            int axisMask = 1;
                            while (axis < 3) {
                                int startAxisValue = edgeStart & axisMask;
                                int endAxisValue = edgeEnd & axisMask;
                                float axisInterpValue = startAxisValue != endAxisValue ? (startAxisValue != 0 ? 1.0f - t : t) : (startAxisValue != 0 ? 1.0f : 0.0f);
                                int n2 = axis++;
                                vertexUntilIFigureOutTheInterpolationAndIntersection[n2] = vertexUntilIFigureOutTheInterpolationAndIntersection[n2] + axisInterpValue;
                                axisMask <<= 1;
                            }
                        }
                        float s = 1.0f / (float)edgeCrossings;
                        Vec vertex = new Vec(vertexUntilIFigureOutTheInterpolationAndIntersection[0], vertexUntilIFigureOutTheInterpolationAndIntersection[1], vertexUntilIFigureOutTheInterpolationAndIntersection[2]);
                        vertex.x = (float)x + s * vertex.x;
                        vertex.y = (float)y + s * vertex.y;
                        vertex.z = (float)z + s * vertex.z;
                        verticesBuffer[bufferPointer] = vertex;
                        for (int axis = 0; axis < 3; ++axis) {
                            if ((edge_mask & 1 << axis) == 0) continue;
                            int nextAxis = (axis + 1) % 3;
                            int nextNextAxis = (axis + 2) % 3;
                            if (nextAxis == 0 && x == 0 || nextAxis == 1 && y == 0 || nextAxis == 2 && z == 0 || nextNextAxis == 0 && x == 0 || nextNextAxis == 1 && y == 0 || nextNextAxis == 2 && z == 0) continue;
                            int du = axisMultipliers[nextAxis];
                            int dv = axisMultipliers[nextNextAxis];
                            if ((mask & 1) != 0) {
                                face.set(verticesBuffer[bufferPointer], verticesBuffer[bufferPointer - dv], verticesBuffer[bufferPointer - du - dv], verticesBuffer[bufferPointer - du]);
                            } else {
                                face.set(verticesBuffer[bufferPointer], verticesBuffer[bufferPointer - du], verticesBuffer[bufferPointer - du - dv], verticesBuffer[bufferPointer - dv]);
                            }
                            face.flip();
                            pos.m_122178_(x, y, z);
                            if (action.apply(pos, face)) continue;
                            return;
                        }
                    }
                    ++x;
                    ++n;
                    ++bufferPointer;
                }
                ++y;
                ++n;
                bufferPointer += 2;
            }
            ++z;
            n += dims.m_123341_();
            buf_no ^= 1;
            axisMultipliers[2] = -axisMultipliers[2];
        }
    }

    private static float getAmountInsideIsosurface(boolean smoother, float[] cornerDistances) {
        if (!smoother) {
            float voxelDensity = 0.0f;
            for (int corner = 0; corner < 8; ++corner) {
                float cornerDensity = -cornerDistances[corner];
                voxelDensity += (cornerDensity + 1.0f) / 2.0f;
            }
            return voxelDensity / 8.0f;
        }
        float combinedDistance = 0.0f;
        for (int corner = 0; corner < 8; ++corner) {
            combinedDistance += cornerDistances[corner];
        }
        float averageDistance = combinedDistance / 8.0f;
        float voxelDensity = -averageDistance;
        return (voxelDensity + 1.0f) / 2.0f;
    }

    static final class Lookup {
        public static final int[] CUBE_EDGES = new int[24];
        public static final int[] EDGE_TABLE = new int[256];

        Lookup() {
        }

        private static void generateCubeEdgesTable() {
            int cubeEdgesIndex = 0;
            for (int cubeCornerIndex = 0; cubeCornerIndex < 8; cubeCornerIndex = (int)((byte)(cubeCornerIndex + 1))) {
                for (int em = 1; em <= 4; em <<= 1) {
                    int j = cubeCornerIndex ^ em;
                    if (cubeCornerIndex > j) continue;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = cubeCornerIndex;
                    Lookup.CUBE_EDGES[cubeEdgesIndex++] = j;
                }
            }
        }

        private static void generateIntersectionTable() {
            for (int edgeTableIndex = 0; edgeTableIndex < 256; edgeTableIndex = (int)((short)(edgeTableIndex + 1))) {
                int em = 0;
                for (int cubeEdgesIndex = 0; cubeEdgesIndex < 24; cubeEdgesIndex += 2) {
                    boolean a = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex]) != 0;
                    boolean b = (edgeTableIndex & 1 << CUBE_EDGES[cubeEdgesIndex + 1]) != 0;
                    em = (short)(em | (a != b ? 1 << (cubeEdgesIndex >> 1) : 0));
                }
                Lookup.EDGE_TABLE[edgeTableIndex] = em;
            }
        }

        static {
            Lookup.generateCubeEdgesTable();
            Lookup.generateIntersectionTable();
        }
    }
}

