/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.mesh.TestData;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.ThreadLocalArrayCache;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

abstract class SDFMesher
implements Mesher {
    public static final short MASK_FULLY_OUTSIDE_ISOSURFACE = 0;
    public static final short MASK_FULLY_INSIDE_ISOSURFACE = 255;
    private static final ThreadLocalArrayCache<float[]> CACHE = new ThreadLocalArrayCache<float[]>(float[]::new, array -> ((float[])array).length);
    protected final boolean smoothness2x;

    protected SDFMesher(boolean smoothness2x) {
        this.smoothness2x = smoothness2x;
    }

    protected static BlockPos getDimensions(Area area, boolean smoother, @Nullable TestData.TestMesh testMesh) {
        return testMesh == null ? SDFMesher.getDimensions(area, smoother) : testMesh.dimensions;
    }

    protected static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable, boolean smoother, @Nullable TestData.TestMesh testMesh) {
        return testMesh == null ? SDFMesher.generateDistanceField(area, isSmoothable, smoother) : testMesh.generateDistanceField(area.start.m_123341_(), area.start.m_123342_(), area.start.m_123343_());
    }

    private static BlockPos getDimensions(Area area, boolean smoother) {
        return smoother ? area.size.m_121996_((Vec3i)ModUtil.VEC_ONE) : area.size;
    }

    private static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable, boolean smoother) {
        return smoother ? SDFMesher.generateDistanceField(area, isSmoothable) : SDFMesher.generateNegativeDensityField(area, isSmoothable);
    }

    private static float[] generateDistanceField(Area area, Predicate<BlockState> isSmoothable) {
        BlockState[] states = area.getAndCacheBlocks();
        int areaX = area.size.m_123341_();
        int areaY = area.size.m_123342_();
        int areaZ = area.size.m_123343_();
        int distanceFieldSizeX = areaX - 1;
        int distanceFieldSizeY = areaY - 1;
        int distanceFieldSizeZ = areaZ - 1;
        int distanceFieldSize = distanceFieldSizeX * distanceFieldSizeY * distanceFieldSizeZ;
        float[] distanceField = CACHE.takeArray(distanceFieldSize);
        int index = 0;
        for (int z = 0; z < areaZ; ++z) {
            for (int y = 0; y < areaY; ++y) {
                int x = 0;
                while (x < areaX) {
                    if (z != distanceFieldSizeZ && y != distanceFieldSizeY && x != distanceFieldSizeX) {
                        int combinedDensity = 0;
                        int neighbourIndex = index;
                        int neighbourZ = 0;
                        while (neighbourZ < 2) {
                            int neighbourY = 0;
                            while (neighbourY < 2) {
                                int neighbourX = 0;
                                while (neighbourX < 2) {
                                    combinedDensity = (int)((float)combinedDensity + ModUtil.getBlockDensity(isSmoothable, states[neighbourIndex]));
                                    ++neighbourX;
                                    ++neighbourIndex;
                                }
                                ++neighbourY;
                                neighbourIndex += areaX - 2;
                            }
                            ++neighbourZ;
                            neighbourIndex += areaX * (areaY - 2);
                        }
                        int distanceFieldIndex = ModUtil.get3dIndexInto1dArray(x, y, z, distanceFieldSizeX, distanceFieldSizeY);
                        distanceField[distanceFieldIndex] = (float)(-combinedDensity) / 8.0f;
                    }
                    ++x;
                    ++index;
                }
            }
        }
        return distanceField;
    }

    static float[] generateNegativeDensityField(Area area, Predicate<BlockState> isSmoothable) {
        BlockState[] states = area.getAndCacheBlocks();
        int length = area.numBlocks();
        float[] densityField = CACHE.takeArray(length);
        for (int i = 0; i < length; ++i) {
            densityField[i] = -ModUtil.getBlockDensity(isSmoothable, states[i]);
        }
        return densityField;
    }

    static interface FullCellAction {
        public static final FullCellAction IGNORE = (x, y, z) -> true;

        public boolean apply(double var1, double var3, double var5);
    }
}

