/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.mesh;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cadiboo.nocubes.collision.ShapeConsumer;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;

public interface Mesher {
    default public void generateGeometry(Area area, Predicate<BlockState> isSmoothable, FaceAction action) {
        try {
            this.generateGeometryInternal(area, isSmoothable, action);
        }
        catch (Throwable t) {
            Util.m_137570_((Throwable)t);
            throw t;
        }
    }

    default public void generateCollisions(Area area, Predicate<BlockState> isSmoothable, ShapeConsumer action) {
        try {
            this.generateCollisionsInternal(area, isSmoothable, action);
        }
        catch (Throwable t) {
            Util.m_137570_((Throwable)t);
            throw t;
        }
    }

    public void generateGeometryInternal(Area var1, Predicate<BlockState> var2, FaceAction var3);

    public void generateCollisionsInternal(Area var1, Predicate<BlockState> var2, ShapeConsumer var3);

    public Vec3i getPositiveAreaExtension();

    public Vec3i getNegativeAreaExtension();

    default public boolean isOutsideMesh(int x, int y, int z, BlockPos size) {
        Vec3i negativeExtension = this.getNegativeAreaExtension();
        Vec3i positiveExtension = this.getPositiveAreaExtension();
        return x >= size.m_123341_() - positiveExtension.m_123341_() || x < negativeExtension.m_123341_() || y >= size.m_123342_() - positiveExtension.m_123342_() || y < negativeExtension.m_123342_() || z >= size.m_123343_() - positiveExtension.m_123343_() || z < negativeExtension.m_123343_();
    }

    public static void translateToMeshStart(PoseStack matrix, BlockPos areaStart, BlockPos renderStartPos) {
        matrix.m_85837_((double)Mesher.getMeshOffset(areaStart.m_123341_(), renderStartPos.m_123341_()), (double)Mesher.getMeshOffset(areaStart.m_123342_(), renderStartPos.m_123342_()), (double)Mesher.getMeshOffset(areaStart.m_123343_(), renderStartPos.m_123343_()));
    }

    public static int getMeshOffset(int areaStart, int desiredStart) {
        return Mesher.validateMeshOffset(areaStart - desiredStart);
    }

    public static int validateMeshOffset(int meshOffset) {
        if (!1.$assertionsDisabled && meshOffset > 0) {
            throw new AssertionError((Object)"Meshers won't require a smaller area than they are generating a mesh for");
        }
        if (!1.$assertionsDisabled && meshOffset <= -3) {
            throw new AssertionError((Object)"Meshers won't require more than 2 extra blocks on each axis");
        }
        return meshOffset;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static interface FaceAction {
        public boolean apply(BlockPos.MutableBlockPos var1, Face var2);
    }
}

