/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.hooks;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.ClientUtil;
import io.github.cadiboo.nocubes.client.render.RendererDispatcher;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.hooks.SelfCheck;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.util.Set;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class Hooks {
    public static boolean renderingEnabledFor(BlockBehaviour.BlockStateBase state) {
        return NoCubesConfig.Client.render && NoCubes.smoothableHandler.isSmoothable(state);
    }

    public static boolean collisionsEnabledFor(BlockBehaviour.BlockStateBase state) {
        return NoCubesConfig.Server.collisionsEnabled && NoCubes.smoothableHandler.isSmoothable(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void preIteration(ChunkRenderDispatcher.RenderChunk.RebuildTask rebuildTask, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack buffers, BlockPos chunkPos, BlockAndTintGetter world, PoseStack matrix, Set<RenderType> usedLayers, RandomSource random, BlockRenderDispatcher dispatcher) {
        SelfCheck.preIteration = true;
        RendererDispatcher.renderChunk(rebuildTask, chunkRender, buffers, chunkPos, world, matrix, usedLayers, random, dispatcher);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static FluidState getRenderFluidState(BlockPos pos, BlockState state) {
        SelfCheck.getRenderFluidState = true;
        if (NoCubesConfig.Server.extendFluidsRange > 0) {
            return ClientUtil.getExtendedFluidState(pos);
        }
        return state.m_60819_();
    }

    public static boolean allowVanillaRenderingFor(BlockState state) {
        if (!NoCubesConfig.Client.render) {
            return true;
        }
        if (NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return false;
        }
        return !NoCubesConfig.Client.fixPlantHeight || !ModUtil.isShortPlant(state);
    }

    public static boolean shouldCancelOcclusion(BlockBehaviour.BlockStateBase state) {
        return Hooks.renderingEnabledFor(state);
    }
}

