/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.RenderHelper;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.mesh.CullingChamfer;
import io.github.cadiboo.nocubes.mesh.CullingCubic;
import io.github.cadiboo.nocubes.mesh.MarchingCubes;
import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.mesh.OldNoCubes;
import io.github.cadiboo.nocubes.mesh.StupidCubic;
import io.github.cadiboo.nocubes.mesh.SurfaceNets;
import io.github.cadiboo.nocubes.network.NoCubesNetwork;
import io.github.cadiboo.nocubes.network.S2CUpdateServerConfig;
import io.github.cadiboo.nocubes.util.BlockStateConverter;
import io.github.cadiboo.nocubes.util.ModUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.IConfigEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NoCubesConfig {
    private static final Logger LOG = LogManager.getLogger();

    public static void register(ModLoadingContext context, IEventBus modBus) {
        Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)ModConfig.Type.CLIENT, (Object)Client.SPEC), Pair.of((Object)ModConfig.Type.SERVER, (Object)Server.SPEC)}).forEach(pair -> context.registerConfig((ModConfig.Type)pair.getKey(), (IConfigSpec)pair.getValue()));
        modBus.addListener(event -> {
            ModConfig config = event.getConfig();
            IConfigSpec spec = config.getSpec();
            LOG.debug("Received config event for {}", (Object)config.getFileName());
            if (spec == Client.SPEC) {
                Client.bake(config);
            } else if (spec == Server.SPEC) {
                Server.bake(config);
            }
        });
    }

    public static class Client {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static boolean render;
        public static ColorParser.Color selectionBoxColor;
        public static boolean betterGrassSides;
        public static boolean moreSnow;
        public static boolean fixPlantHeight;
        public static boolean grassTufts;
        public static boolean debugEnabled;
        public static boolean debugOutlineSmoothables;
        public static boolean debugVisualiseDensitiesGrid;
        public static boolean debugRenderCollisions;
        public static boolean debugRenderMeshCollisions;
        public static boolean debugRecordMeshPerformance;
        public static boolean debugOutlineNearbyMesh;

        public static void bake(ModConfig config) {
            LOG.debug("Baking config {}", (Object)config.getFileName());
            boolean oldRender = render;
            int oldChunkRenderSettingsHash = Client.hashChunkRenderSettings();
            render = Server.forceVisuals || (Boolean)Client.INSTANCE.render.get() != false;
            selectionBoxColor = ColorParser.parse((String)Client.INSTANCE.selectionBoxColor.get());
            betterGrassSides = (Boolean)Client.INSTANCE.betterGrassSides.get();
            moreSnow = (Boolean)Client.INSTANCE.moreSnow.get();
            fixPlantHeight = (Boolean)Client.INSTANCE.fixPlantHeight.get();
            grassTufts = (Boolean)Client.INSTANCE.grassTufts.get();
            if (oldRender != render) {
                RenderHelper.reloadAllChunks("custom rendering was toggled to %b in the client config", render);
            } else if (render && oldChunkRenderSettingsHash != Client.hashChunkRenderSettings()) {
                RenderHelper.reloadAllChunks("options affecting chunk rendering in the client config were changed", new Object[0]);
            }
            debugEnabled = (Boolean)Client.INSTANCE.debugEnabled.get();
            debugOutlineSmoothables = (Boolean)Client.INSTANCE.debugOutlineSmoothables.get();
            debugVisualiseDensitiesGrid = (Boolean)Client.INSTANCE.debugVisualiseDensitiesGrid.get();
            debugRenderCollisions = (Boolean)Client.INSTANCE.debugRenderCollisions.get();
            debugRenderMeshCollisions = (Boolean)Client.INSTANCE.debugRenderMeshCollisions.get();
            debugRecordMeshPerformance = (Boolean)Client.INSTANCE.debugRecordMeshPerformance.get();
            debugOutlineNearbyMesh = (Boolean)Client.INSTANCE.debugOutlineNearbyMesh.get();
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(betterGrassSides, moreSnow, fixPlantHeight, grassTufts);
        }

        public static void updateRender(boolean newValue) {
            Client.INSTANCE.render.set((Object)newValue);
            Client.saveAndLoad();
        }

        private static void saveAndLoad() {
            Hacks.saveAndLoad(ModConfig.Type.CLIENT);
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Impl::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.BooleanValue render;
            final ForgeConfigSpec.ConfigValue<String> selectionBoxColor;
            final ForgeConfigSpec.BooleanValue betterGrassSides;
            final ForgeConfigSpec.BooleanValue moreSnow;
            final ForgeConfigSpec.BooleanValue fixPlantHeight;
            final ForgeConfigSpec.BooleanValue grassTufts;
            final ForgeConfigSpec.BooleanValue debugEnabled;
            final ForgeConfigSpec.BooleanValue debugOutlineSmoothables;
            final ForgeConfigSpec.BooleanValue debugVisualiseDensitiesGrid;
            final ForgeConfigSpec.BooleanValue debugRenderCollisions;
            final ForgeConfigSpec.BooleanValue debugRenderMeshCollisions;
            final ForgeConfigSpec.BooleanValue debugRecordMeshPerformance;
            final ForgeConfigSpec.BooleanValue debugOutlineNearbyMesh;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.render = builder.translation("nocubes.config.render").comment("If NoCubes' custom rendering is enabled").define("render", true);
                this.selectionBoxColor = builder.translation("nocubes.config.selectionBoxColor").comment(new String[]{"The color of the outline (selection box) over a smoothed block.", "Supports pretty much any format you can imagine.", "Some examples of ways to define colors:", "By name: \"red\"", "By name: \"firebrick\" (a red-orangeish color)", "By name: \"gainsboro\" (a light gray color)", "With RGB (red, green, blue) integers (0-255): \"rgb(255, 0, 0)\" (pure red)", "With RGB (red, green, blue) floats (0.0-1.0): \"rgb(1.0, 0, 0)\" (also pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(255, 0, 0, 0.5)\" (partially transparent pure red)", "With RGBA (red, green, blue, alpha) integers (0-255): \"rgba(1.0, 0, 0, 1.0)\" (also partially transparent pure red)", "With hexadecimal (case insensitive) RGB (red, green, blue) integers (00-FF): \"0x0ff\" (aqua)", "With hexadecimal (case insensitive) RGBA (red, green, blue, alpha) integers (00-FF): \"#0FF6\" (partially transparent aqua)", "With HSL (hue, saturation, lightness): \"hsl(270, 100%, 100%)\" (a dark purple)", "With HSLA (hue, saturation, lightness, alpha): \"hsla(270, 100%, 100%, 0.5)\" (a partially transparent dark purple)"}).define("selectionBoxColor", (Object)"#0006");
                this.betterGrassSides = builder.translation("nocubes.config.betterGrassSides").comment(new String[]{"Similar to OptiFine's 'Better Grass' feature", "OFF - The sides of grass blocks have the default texture", "ON - The sides of grass blocks have the texture of the top of the block"}).define("betterGrassSides", false);
                this.moreSnow = builder.translation("nocubes.config.moreSnow").comment(new String[]{"Similar to OptiFine's 'Better Snow' feature", "OFF - The sides of blocks nearby snow have their own texture", "ON - The sides of blocks nearby snow have the snow texture"}).define("moreSnow", false);
                this.fixPlantHeight = builder.translation("nocubes.config.fixPlantHeight").comment("If small plants like flowers and grass should be moved onto NoCubes' terrain").define("fixPlantHeight", false);
                this.grassTufts = builder.translation("nocubes.config.grassTufts").comment("If small tufts of grass should be rendered on top of grass blocks, similar to BetterFoliage's 'Short Grass' feature").define("grassTufts", false);
                builder.push("debug");
                this.debugEnabled = builder.translation("nocubes.config.debugEnabled").comment("If debugging features should be enabled").define("debugEnabled", false);
                this.debugOutlineSmoothables = builder.define("debugOutlineSmoothables", false);
                this.debugVisualiseDensitiesGrid = builder.define("debugVisualiseDensitiesGrid", false);
                this.debugRenderCollisions = builder.define("debugRenderCollisions", false);
                this.debugRenderMeshCollisions = builder.define("debugRenderMeshCollisions", false);
                this.debugRecordMeshPerformance = builder.define("debugRecordMeshPerformance", false);
                this.debugOutlineNearbyMesh = builder.define("debugOutlineNearbyMesh", false);
                builder.pop();
            }
        }
    }

    public static class Server {
        public static final Impl INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public static Mesher mesher;
        public static boolean collisionsEnabled;
        public static boolean tempMobCollisionsDisabled;
        public static boolean forceVisuals;
        public static int extendFluidsRange;
        public static float oldNoCubesRoughness;

        public static void bake(ModConfig config) {
            LOG.debug("Baking config {}", (Object)config.getFileName());
            int oldChunkRenderSettingsHash = Server.hashChunkRenderSettings();
            Smoothables.recomputeInMemoryLookup((List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            mesher = ((MesherType)((Object)Server.INSTANCE.mesher.get())).instance;
            collisionsEnabled = (Boolean)Server.INSTANCE.collisionsEnabled.get();
            tempMobCollisionsDisabled = (Boolean)Server.INSTANCE.tempMobCollisionsDisabled.get();
            forceVisuals = (Boolean)Server.INSTANCE.forceVisuals.get();
            if (forceVisuals) {
                Client.render = true;
            }
            extendFluidsRange = Server.validateRange(0, 2, (Integer)Server.INSTANCE.extendFluidsRange.get(), "extendFluidsRange");
            oldNoCubesRoughness = Server.validateRange(0.0, 1.0, (Double)Server.INSTANCE.oldNoCubesRoughness.get(), "oldNoCubesRoughness").floatValue();
            if (oldChunkRenderSettingsHash != Server.hashChunkRenderSettings()) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RenderHelper.reloadAllChunks("options affecting chunk rendering in the server config were changed", new Object[0]));
            }
            if (FMLEnvironment.dist.isDedicatedServer() && ServerLifecycleHooks.getCurrentServer() != null) {
                NoCubesNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)S2CUpdateServerConfig.create(config));
            }
        }

        private static <T extends Number> T validateRange(T min, T max, T value, String name) {
            if (((Comparable)((Object)value)).compareTo(min) < 0 || ((Comparable)((Object)value)).compareTo(max) > 0) {
                throw new IllegalStateException("Config was not validated! '" + name + "' must be between " + min + " and " + max + " but was " + value);
            }
            return value;
        }

        private static int hashChunkRenderSettings() {
            return Objects.hash(mesher, forceVisuals);
        }

        public static void updateSmoothable(boolean newValue, BlockState ... states) {
            Smoothables.updateSmoothables(newValue, states, (List)Server.INSTANCE.smoothableWhitelist.get(), (List)Server.INSTANCE.smoothableBlacklist.get());
            Server.saveAndLoad();
        }

        private static void saveAndLoad() {
            Hacks.saveAndLoad(ModConfig.Type.SERVER);
        }

        static {
            Pair specPair = new ForgeConfigSpec.Builder().configure(Impl::new);
            SPEC = (ForgeConfigSpec)specPair.getRight();
            INSTANCE = (Impl)specPair.getLeft();
        }

        static class Impl {
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableWhitelist;
            final ForgeConfigSpec.ConfigValue<List<? extends String>> smoothableBlacklist;
            final ForgeConfigSpec.EnumValue<MesherType> mesher;
            final ForgeConfigSpec.BooleanValue collisionsEnabled;
            final ForgeConfigSpec.BooleanValue tempMobCollisionsDisabled;
            final ForgeConfigSpec.BooleanValue forceVisuals;
            final ForgeConfigSpec.IntValue extendFluidsRange;
            final ForgeConfigSpec.DoubleValue oldNoCubesRoughness;

            private Impl(ForgeConfigSpec.Builder builder) {
                this.smoothableWhitelist = builder.translation("nocubes.config.smoothableWhitelist").comment("What blocks should be smoothed by NoCubes (same syntax as the /setblock command)").defineListAllowEmpty(Collections.singletonList("smoothableWhitelist"), Lists::newArrayList, String.class::isInstance);
                this.smoothableBlacklist = builder.translation("nocubes.config.smoothableBlacklist").comment("What blocks should not be smoothed by NoCubes (same syntax as the /setblock command)").defineListAllowEmpty(Collections.singletonList("smoothableBlacklist"), Lists::newArrayList, String.class::isInstance);
                this.collisionsEnabled = builder.translation("nocubes.config.collisionsEnabled").comment("If players should be able to walk up the smooth slopes generated by NoCubes").define("collisionsEnabled", true);
                this.tempMobCollisionsDisabled = builder.translation("nocubes.config.tempMobCollisionsDisabled").comment("If ONLY players should be able to walk up the smooth slopes generated by NoCubes").define("tempMobCollisionsDisabled", false);
                this.mesher = builder.translation("nocubes.config.meshGenerator").comment("meshGenerator").defineEnum("meshGenerator", (Enum)MesherType.SurfaceNets);
                this.forceVisuals = builder.translation("nocubes.config.forceVisuals").comment(new String[]{"For MMO servers that require NoCubes to be enabled for a proper player experience.", "If you enable this make sure that you've manually checked that every chunk is navigable!"}).define("forceVisuals", false);
                this.extendFluidsRange = builder.translation("nocubes.config.extendFluidsRange").comment("The range at which to extend fluids (water & lava) into smoothable blocks").defineInRange("extendFluidsRange", 1, 0, 2);
                this.oldNoCubesRoughness = builder.translation("nocubes.config.oldNoCubesRoughness").comment("How much pseudo-random roughness should be applied to mesh generated by OldNoCubes").defineInRange("oldNoCubesRoughness", 0.5, 0.0, 1.0);
            }
        }

        public static enum MesherType {
            SurfaceNets(new SurfaceNets(false)),
            OldNoCubes(new OldNoCubes()),
            Debug_SurfaceNets2xSmoothness(new SurfaceNets(true)),
            Debug_MarchingCubes(new MarchingCubes(false)),
            Debug_MarchingCubes2xSmoothness(new MarchingCubes(true)),
            Debug_CullingCubic(new CullingCubic()),
            Debug_StupidCubic(new StupidCubic()),
            Debug_CullingChamfer(new CullingChamfer());

            public final Mesher instance;

            private MesherType(Mesher instance) {
                this.instance = instance;
            }
        }
    }

    public static class Smoothables {
        private static final Set<BlockState> DEFAULT_SMOOTHABLES = Sets.newIdentityHashSet();

        static void updateSmoothables(boolean newValue, BlockState[] states, List<String> whitelist, List<String> blacklist) {
            LOG.debug("Updating user-defined smoothable string lists");
            List<String> toAddTo = newValue ? whitelist : blacklist;
            List<String> toRemoveFrom = newValue ? blacklist : whitelist;
            for (BlockState state : states) {
                String string = BlockStateConverter.toString(state);
                NoCubes.smoothableHandler.setSmoothable(newValue, (BlockBehaviour.BlockStateBase)state);
                if (!toAddTo.contains(string)) {
                    toAddTo.add(string);
                }
                while (toRemoveFrom.remove(string)) {
                }
            }
        }

        static void recomputeInMemoryLookup(List<? extends String> whitelist, List<? extends String> blacklist) {
            LOG.debug("Recomputing in-memory smoothable lookups from user-defined smoothable string lists");
            Set<BlockState> whitelisted = Smoothables.parseBlockStates(whitelist);
            Set<BlockState> blacklisted = Smoothables.parseBlockStates(blacklist);
            ForgeRegistries.BLOCKS.getValues().parallelStream().flatMap(block -> ModUtil.getStates(block).parallelStream()).forEach(state -> {
                boolean smoothable = (whitelisted.contains(state) || DEFAULT_SMOOTHABLES.contains(state)) && !blacklisted.contains(state);
                NoCubes.smoothableHandler.setSmoothable(smoothable, (BlockBehaviour.BlockStateBase)state);
            });
        }

        static Set<BlockState> parseBlockStates(List<? extends String> list) {
            Set set = Sets.newIdentityHashSet();
            list.parallelStream().map(BlockStateConverter::fromStringOrNull).filter(Objects::nonNull).forEach(set::add);
            return set;
        }

        public static void addDefault(BlockState ... states) {
            DEFAULT_SMOOTHABLES.addAll(Arrays.asList(states));
        }

        static {
            DEFAULT_SMOOTHABLES.addAll(Arrays.stream(new Block[]{Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_50440_, Blocks.f_50493_, Blocks.f_50546_, Blocks.f_50599_, Blocks.f_50195_, Blocks.f_152550_, Blocks.f_152549_, Blocks.f_152496_, Blocks.f_152497_, Blocks.f_152597_, Blocks.f_152490_, Blocks.f_152491_, Blocks.f_50752_, Blocks.f_49992_, Blocks.f_49993_, Blocks.f_50062_, Blocks.f_50394_, Blocks.f_49994_, Blocks.f_49997_, Blocks.f_49996_, Blocks.f_152505_, Blocks.f_49995_, Blocks.f_50173_, Blocks.f_50089_, Blocks.f_50059_, Blocks.f_50264_, Blocks.f_50331_, Blocks.f_49998_, Blocks.f_152469_, Blocks.f_152468_, Blocks.f_152506_, Blocks.f_152467_, Blocks.f_152473_, Blocks.f_152474_, Blocks.f_152472_, Blocks.f_152479_, Blocks.f_50226_, Blocks.f_152596_, Blocks.f_50453_, Blocks.f_152481_, Blocks.f_50129_, Blocks.f_50352_, Blocks.f_50287_, Blocks.f_50288_, Blocks.f_50289_, Blocks.f_50290_, Blocks.f_50291_, Blocks.f_50292_, Blocks.f_50293_, Blocks.f_50294_, Blocks.f_50295_, Blocks.f_50296_, Blocks.f_50297_, Blocks.f_50298_, Blocks.f_50299_, Blocks.f_50300_, Blocks.f_50301_, Blocks.f_50302_, Blocks.f_50125_, Blocks.f_50127_, Blocks.f_50126_, Blocks.f_50354_, Blocks.f_50449_, Blocks.f_50134_, Blocks.f_50135_, Blocks.f_50136_, Blocks.f_50137_, Blocks.f_50450_, Blocks.f_50141_, Blocks.f_50451_, Blocks.f_50695_, Blocks.f_50690_, Blocks.f_50692_, Blocks.f_50686_, Blocks.f_50259_, Blocks.f_49999_, Blocks.f_50000_, Blocks.f_50001_, Blocks.f_50002_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50050_, Blocks.f_50051_, Blocks.f_50052_, Blocks.f_50053_, Blocks.f_50054_, Blocks.f_50055_}).flatMap(block -> ModUtil.getStates(block).stream()).collect(Collectors.toList()));
            DEFAULT_SMOOTHABLES.addAll(Arrays.stream(new BlockState[0]).collect(Collectors.toList()));
            DEFAULT_SMOOTHABLES.addAll(Smoothables.parseBlockStates(Arrays.asList("biomesoplenty:grass[snowy=false,variant=sandy]", "biomesoplenty:dirt[coarse=false,variant=sandy]", "biomesoplenty:white_sand", "biomesoplenty:grass[snowy=false,variant=silty]", "biomesoplenty:dirt[coarse=false,variant=loamy]", "biomesoplenty:grass[snowy=false,variant=loamy]", "biomesoplenty:dried_sand", "biomesoplenty:hard_ice", "biomesoplenty:mud[variant=mud]", "biomesoplenty:dirt[coarse=false,variant=silty]", "chisel:marble2[variation=7]", "chisel:limestone2[variation=7]", "dynamictrees:rootydirtspecies[life=0]", "dynamictrees:rootysand[life=0]", "iceandfire:ash", "iceandfire:sapphire_ore", "iceandfire:chared_grass", "iceandfire:chared_stone", "iceandfire:frozen_grass_path", "notenoughroofs:copper_ore", "rustic:slate")));
        }
    }

    public static class Hacks {
        static void saveAndLoad(ModConfig.Type type) {
            LOG.debug("Saving and loading {} config", (Object)type.name());
            Hacks.ConfigTracker_getConfig(type).ifPresent(modConfig -> {
                LOG.debug("Found {} ModConfig to save and load", (Object)type.name());
                modConfig.save();
                ((CommentedFileConfig)modConfig.getConfigData()).load();
                modConfig.getSpec().afterReload();
                Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.reloading((ModConfig)modConfig));
            });
        }

        public static void loadDefaultServerConfig() {
            LOG.debug("Loading default server config");
            Hacks.ConfigTracker_getConfig(ModConfig.Type.SERVER).ifPresent(modConfig -> {
                LOG.debug("Found ModConfig to load as default");
                CommentedConfig config = CommentedConfig.inMemory();
                modConfig.getSpec().correct(config);
                Hacks.ModConfig_setConfigData(modConfig, config);
                Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.loading((ModConfig)modConfig));
            });
        }

        private static Optional<ModConfig> ConfigTracker_getConfig(ModConfig.Type type) {
            LOG.debug("Getting {} ModConfig from ConfigTracker", (Object)type.name());
            return ((Set)ConfigTracker.INSTANCE.configSets().get(type)).stream().filter(modConfig -> modConfig.getModId().equals("nocubes")).findFirst();
        }

        private static void ModConfig_setConfigData(ModConfig modConfig, CommentedConfig data) {
            LOG.debug("Setting ModConfig config data");
            Method setConfigData = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfigData", (Class[])new Class[]{CommentedConfig.class});
            try {
                setConfigData.invoke((Object)modConfig, data);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Could not set config data for config " + modConfig, e);
            }
        }

        private static void ModConfig_fireEvent(ModConfig modConfig, IConfigEvent event) {
            LOG.debug("Firing ModConfig event");
            ((ModContainer)ModList.get().getModContainerById(modConfig.getModId()).get()).dispatchConfigEvent(event);
        }

        public static void receiveSyncedServerConfig(S2CUpdateServerConfig s2CConfigData) {
            LOG.debug("Setting logical server config (on the client) from server sync packet");
            assert (FMLEnvironment.dist.isClient()) : "This packet should have only be sent server->client";
            ModConfig modConfig = Hacks.ConfigTracker_getConfig(ModConfig.Type.SERVER).get();
            ConfigParser parser = modConfig.getConfigData().configFormat().createParser();
            Hacks.ModConfig_setConfigData(modConfig, (CommentedConfig)parser.parse((InputStream)new ByteArrayInputStream(s2CConfigData.getBytes())));
            Hacks.ModConfig_fireEvent(modConfig, IConfigEvent.reloading((ModConfig)modConfig));
        }
    }
}

