/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render.struct;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;

public final class Texture {
    public static final Texture EVERYTHING = new Texture(0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f);
    public float u0;
    public float v0;
    public float u1;
    public float v1;
    public float u2;
    public float v2;
    public float u3;
    public float v3;

    public Texture() {
        this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Texture(float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
        this.u2 = u2;
        this.v2 = v2;
        this.u3 = u3;
        this.v3 = v3;
    }

    public static Texture forQuadRearranged(Texture valhallaPls, BakedQuad quad, Direction faceDirection) {
        valhallaPls = Texture.forQuad(valhallaPls, quad);
        valhallaPls.rearrangeForDirection(faceDirection);
        return valhallaPls;
    }

    public static Texture forQuad(Texture valhallaPls, BakedQuad quad) {
        valhallaPls.unpackFromQuad(quad);
        return valhallaPls;
    }

    private void unpackFromQuad(BakedQuad quad) {
        int formatSize = Texture.getFormatSize(quad);
        int[] vertexData = quad.m_111303_();
        this.u0 = Float.intBitsToFloat(vertexData[4]);
        this.v0 = Float.intBitsToFloat(vertexData[5]);
        this.u1 = Float.intBitsToFloat(vertexData[formatSize + 4]);
        this.v1 = Float.intBitsToFloat(vertexData[formatSize + 5]);
        this.u2 = Float.intBitsToFloat(vertexData[formatSize * 2 + 4]);
        this.v2 = Float.intBitsToFloat(vertexData[formatSize * 2 + 5]);
        this.u3 = Float.intBitsToFloat(vertexData[formatSize * 3 + 4]);
        this.v3 = Float.intBitsToFloat(vertexData[formatSize * 3 + 5]);
    }

    private static int getFormatSize(BakedQuad quad) {
        return DefaultVertexFormat.f_85811_.m_86017_();
    }

    private void rearrangeForDirection(Direction direction) {
        switch (direction) {
            case NORTH: 
            case EAST: {
                break;
            }
            case DOWN: 
            case SOUTH: 
            case WEST: {
                float u0 = this.u0;
                float v0 = this.v0;
                float u1 = this.u1;
                float v1 = this.v1;
                float u2 = this.u2;
                float v2 = this.v2;
                float u3 = this.u3;
                float v3 = this.v3;
                this.u0 = u3;
                this.v0 = v3;
                this.u1 = u0;
                this.v1 = v0;
                this.u2 = u1;
                this.v2 = v1;
                this.u3 = u2;
                this.v3 = v2;
                break;
            }
            case UP: {
                float u0 = this.u0;
                float v0 = this.v0;
                float u1 = this.u1;
                float v1 = this.v1;
                float u2 = this.u2;
                float v2 = this.v2;
                float u3 = this.u3;
                float v3 = this.v3;
                this.u0 = u2;
                this.v0 = v2;
                this.u1 = u3;
                this.v1 = v3;
                this.u2 = u0;
                this.v2 = v0;
                this.u3 = u1;
                this.v3 = v1;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + direction);
            }
        }
    }
}

