/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.RenderHelper;
import io.github.cadiboo.nocubes.client.RollingProfiler;
import io.github.cadiboo.nocubes.client.optifine.OptiFineCompatibility;
import io.github.cadiboo.nocubes.client.optifine.OptiFineProxy;
import io.github.cadiboo.nocubes.client.render.FluentMatrixStack;
import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.client.render.struct.Color;
import io.github.cadiboo.nocubes.client.render.struct.FaceLight;
import io.github.cadiboo.nocubes.client.render.struct.Texture;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.Face;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;

public final class RendererDispatcher {
    private static final RollingProfiler totalProfiler = new RollingProfiler(256);
    private static final RollingProfiler fluidsProfiler = new RollingProfiler(256);
    private static final RollingProfiler meshProfiler = new RollingProfiler(256);

    public static void renderChunk(ChunkRenderDispatcher.RenderChunk.RebuildTask rebuildTask, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack buffers, BlockPos chunkPos, BlockAndTintGetter world, PoseStack matrixStack, Set<RenderType> usedLayers, RandomSource random, BlockRenderDispatcher dispatcher) {
        long start = System.nanoTime();
        FluentMatrixStack matrix = new FluentMatrixStack(matrixStack);
        try (LightCache light = new LightCache(Minecraft.m_91087_().f_91073_, chunkPos, ModUtil.CHUNK_SIZE);
             FluentMatrixStack ignored = matrix.push();){
            OptiFineProxy optiFine = OptiFineCompatibility.proxy();
            optiFine.preRenderChunk(chunkRender, chunkPos, matrixStack);
            ChunkRenderInfo renderer = new ChunkRenderInfo(rebuildTask, chunkRender, buffers, chunkPos, world, matrix, usedLayers, random, dispatcher, light, optiFine);
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            RendererDispatcher.renderChunkFluids(renderer);
            if (NoCubesConfig.Client.render) {
                RendererDispatcher.renderChunkMesh(renderer, isSmoothable);
            }
        }
        totalProfiler.recordAndLogElapsedNanosChunk(start, "total");
    }

    public static void renderBreakingTexture(BlockRenderDispatcher dispatcher, BlockState state, BlockPos pos, BlockAndTintGetter world, PoseStack matrix, VertexConsumer buffer, ModelData modelData) {
        Mesher mesher = NoCubesConfig.Server.mesher;
        try (Area area = new Area((BlockGetter)Minecraft.m_91087_().f_91073_, pos, ModUtil.VEC_ONE, mesher);){
            MeshRenderer.renderBreakingTexture(state, pos, matrix, buffer, mesher, area);
        }
    }

    private static void renderChunkFluids(ChunkRenderInfo renderer) {
        long start = System.nanoTime();
        fluidsProfiler.recordAndLogElapsedNanosChunk(start, "fluids");
    }

    private static void renderChunkMesh(ChunkRenderInfo renderer, Predicate<BlockState> isSmoothable) {
        long start = System.nanoTime();
        Mesher mesher = NoCubesConfig.Server.mesher;
        try (Area area = new Area((BlockGetter)Minecraft.m_91087_().f_91073_, renderer.chunkPos, ModUtil.CHUNK_SIZE, mesher);
             FluentMatrixStack ignored = renderer.matrix.push();){
            MeshRenderer.renderArea(renderer, isSmoothable, mesher, area);
        }
        meshProfiler.recordAndLogElapsedNanosChunk(start, "mesh");
    }

    public static BufferBuilder getAndStartBuffer(ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack buffers, Set<RenderType> usedLayers, RenderType layer) {
        BufferBuilder buffer = buffers.m_108839_(layer);
        if (usedLayers.add(layer)) {
            chunkRender.m_112805_(buffer);
        }
        return buffer;
    }

    static void quad(VertexConsumer buffer, PoseStack matrix, Face face, Vec faceNormal, Color color, Texture uvs, FaceLight light, boolean doubleSided) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, face, color, uvs, OverlayTexture.f_118083_, light, faceNormal);
    }

    static void quad(VertexConsumer buffer, PoseStack matrix, boolean doubleSided, Face face, Color color, Texture texture, int overlay, FaceLight light, Vec normal) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, face.v0, color, texture.u0, texture.v0, overlay, light.v0, normal, face.v1, color, texture.u1, texture.v1, overlay, light.v1, normal, face.v2, color, texture.u2, texture.v2, overlay, light.v2, normal, face.v3, color, texture.u3, texture.v3, overlay, light.v3, normal);
    }

    static void quad(VertexConsumer buffer, PoseStack matrix, boolean doubleSided, Vec vec0, Color color0, float u0, float v0, int overlay0, int light0, Vec normal0, Vec vec1, Color color1, float u1, float v1, int overlay1, int light1, Vec normal1, Vec vec2, Color color2, float u2, float v2, int overlay2, int light2, Vec normal2, Vec vec3, Color color3, float u3, float v3, int overlay3, int light3, Vec normal3) {
        RendererDispatcher.quad(buffer, matrix, doubleSided, vec0.x, vec0.y, vec0.z, color0.red, color0.green, color0.blue, color0.alpha, u0, v0, overlay0, light0, normal0.x, normal0.y, normal0.z, vec1.x, vec1.y, vec1.z, color1.red, color1.green, color1.blue, color1.alpha, u1, v1, overlay1, light1, normal1.x, normal1.y, normal1.z, vec2.x, vec2.y, vec2.z, color2.red, color2.green, color2.blue, color2.alpha, u2, v2, overlay2, light2, normal2.x, normal2.y, normal2.z, vec3.x, vec3.y, vec3.z, color3.red, color3.green, color3.blue, color3.alpha, u3, v3, overlay3, light3, normal3.x, normal3.y, normal3.z);
    }

    static void quad(VertexConsumer buffer, PoseStack matrix, boolean doubleSided, float v0x, float v0y, float v0z, float red0, float green0, float blue0, float alpha0, float u0, float v0, int overlay0, int light0, float n0x, float n0y, float n0z, float v1x, float v1y, float v1z, float red1, float green1, float blue1, float alpha1, float u1, float v1, int overlay1, int light1, float n1x, float n1y, float n1z, float v2x, float v2y, float v2z, float red2, float green2, float blue2, float alpha2, float u2, float v2, int overlay2, int light2, float n2x, float n2y, float n2z, float v3x, float v3y, float v3z, float red3, float green3, float blue3, float alpha3, float u3, float v3, int overlay3, int light3, float n3x, float n3y, float n3z) {
        RenderHelper.vertex(buffer, matrix, v0x, v0y, v0z, red0, green0, blue0, alpha0, u0, v0, overlay0, light0, n0x, n0y, n0z);
        RenderHelper.vertex(buffer, matrix, v1x, v1y, v1z, red1, green1, blue1, alpha1, u1, v1, overlay1, light1, n1x, n1y, n1z);
        RenderHelper.vertex(buffer, matrix, v2x, v2y, v2z, red2, green2, blue2, alpha2, u2, v2, overlay2, light2, n2x, n2y, n2z);
        RenderHelper.vertex(buffer, matrix, v3x, v3y, v3z, red3, green3, blue3, alpha3, u3, v3, overlay3, light3, n3x, n3y, n3z);
        if (doubleSided) {
            RenderHelper.vertex(buffer, matrix, v0x, v0y, v0z, red0, green0, blue0, alpha0, u0, v0, overlay0, light0, n0x, n0y, n0z);
            RenderHelper.vertex(buffer, matrix, v3x, v3y, v3z, red3, green3, blue3, alpha3, u3, v3, overlay3, light3, n3x, n3y, n3z);
            RenderHelper.vertex(buffer, matrix, v2x, v2y, v2z, red2, green2, blue2, alpha2, u2, v2, overlay2, light2, n2x, n2y, n2z);
            RenderHelper.vertex(buffer, matrix, v1x, v1y, v1z, red1, green1, blue1, alpha1, u1, v1, overlay1, light1, n1x, n1y, n1z);
        }
    }

    public static class ChunkRenderInfo {
        public final ChunkRenderDispatcher.RenderChunk.RebuildTask rebuildTask;
        public final ChunkRenderDispatcher.RenderChunk chunkRender;
        public final ChunkBufferBuilderPack buffers;
        public final BlockPos chunkPos;
        public final BlockAndTintGetter world;
        public final FluentMatrixStack matrix;
        public final Set<RenderType> usedLayers;
        public final RandomSource random;
        public final BlockRenderDispatcher dispatcher;
        public final LightCache light;
        public final OptiFineProxy optiFine;
        public final BlockColors blockColors;

        public ChunkRenderInfo(ChunkRenderDispatcher.RenderChunk.RebuildTask rebuildTask, ChunkRenderDispatcher.RenderChunk chunkRender, ChunkBufferBuilderPack buffers, BlockPos chunkPos, BlockAndTintGetter world, FluentMatrixStack matrix, Set<RenderType> usedLayers, RandomSource random, BlockRenderDispatcher dispatcher, LightCache light, OptiFineProxy optiFine) {
            this.rebuildTask = rebuildTask;
            this.chunkRender = chunkRender;
            this.buffers = buffers;
            this.chunkPos = chunkPos;
            this.world = world;
            this.matrix = matrix;
            this.usedLayers = usedLayers;
            this.random = random;
            this.dispatcher = dispatcher;
            this.light = light;
            this.optiFine = optiFine;
            this.blockColors = Minecraft.m_91087_().m_91298_();
        }

        public void renderInBlockLayers(BlockState state, BlockPos worldPos, RenderInLayer render) {
            ModelData modelData = this.rebuildTask.getModelData(worldPos);
            ChunkRenderTypeSet layers = ItemBlockRenderTypes.getRenderLayers((BlockState)state);
            for (RenderType layer : layers) {
                BufferBuilder buffer = this.getAndStartBuffer(layer);
                Object renderEnv = this.optiFine.preRenderBlock(this.chunkRender, this.buffers, this.world, layer, buffer, state, worldPos);
                render.render(state, worldPos, modelData, layer, buffer, renderEnv);
                this.optiFine.postRenderBlock(renderEnv, buffer, this.chunkRender, this.buffers, this.usedLayers);
                this.markLayerUsed(layer);
            }
        }

        public Color getColor(Color color, BakedQuad quad, BlockState state, BlockPos pos, float shade) {
            if (!quad.m_111304_()) {
                color.red = shade;
                color.green = shade;
                color.blue = shade;
                return color;
            }
            int packedColor = this.blockColors.m_92577_(state, this.world, pos, quad.m_111305_());
            color.red = (float)(packedColor >> 16 & 0xFF) / 255.0f * shade;
            color.green = (float)(packedColor >> 8 & 0xFF) / 255.0f * shade;
            color.blue = (float)(packedColor & 0xFF) / 255.0f * shade;
            return color;
        }

        public void renderBlock(BlockState stateIn, BlockPos.MutableBlockPos worldPosIn) {
            this.renderInBlockLayers(stateIn, (BlockPos)worldPosIn, (state, worldPos, modelData, layer, buffer, renderEnv) -> this.dispatcher.renderBatched(state, worldPos, this.world, this.matrix.matrix(), (VertexConsumer)buffer, false, this.random, modelData, layer));
        }

        public float getShade(Direction direction) {
            return this.world.m_7717_(direction, true);
        }

        public BufferBuilder getAndStartBuffer(RenderType layer) {
            return RendererDispatcher.getAndStartBuffer(this.chunkRender, this.buffers, this.usedLayers, layer);
        }

        public void markLayerUsed(RenderType layer) {
            this.usedLayers.add(layer);
        }

        public void forEachQuad(BlockState stateIn, BlockPos worldPosIn, Direction direction, ColorSupplier colorSupplier, QuadConsumer action) {
            long rand = this.optiFine.getSeed(stateIn.m_60726_(worldPosIn));
            this.renderInBlockLayers(stateIn, worldPosIn, (state, worldPos, modelData, layer, buffer, renderEnv) -> {
                List<BakedQuad> dirQuads;
                BakedModel model = this.getModel(state, renderEnv);
                List<BakedQuad> nullQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, null);
                boolean anyQuadsFound = this.forEachQuad(nullQuads, state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                if (!state.m_61138_((Property)SnowyDirtBlock.f_56637_)) {
                    dirQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, direction);
                } else if (!((Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_)).booleanValue()) {
                    dirQuads = this.getQuadsAndStoreOverlays(state, worldPos, rand, modelData, layer, renderEnv, model, NoCubesConfig.Client.betterGrassSides ? Direction.UP : direction);
                } else {
                    BlockState snow = Blocks.f_50125_.m_49966_();
                    BakedModel snowModel = this.getModel(snow, renderEnv);
                    dirQuads = this.getQuadsAndStoreOverlays(snow, worldPos, rand, modelData, layer, renderEnv, snowModel, null);
                }
                anyQuadsFound |= this.forEachQuad(dirQuads, state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                int numOverlaysRendered = this.optiFine.forEachOverlayQuad(this, state, worldPos, colorSupplier, action, renderEnv);
                if (!(anyQuadsFound |= numOverlaysRendered > 0)) {
                    this.forEachQuad(this.getMissingQuads(), state, worldPos, colorSupplier, layer, buffer, renderEnv, action);
                }
            });
        }

        private BakedModel getModel(BlockState state, Object renderEnv) {
            BakedModel model = this.dispatcher.m_110910_(state);
            model = this.optiFine.getModel(renderEnv, model, state);
            return model;
        }

        private List<BakedQuad> getQuadsAndStoreOverlays(BlockState state, BlockPos worldPos, long rand, ModelData modelData, RenderType layer, Object renderEnv, BakedModel model, Direction direction) {
            this.random.m_188584_(rand);
            List<BakedQuad> quads = model.getQuads(state, direction, this.random, modelData, layer);
            quads = this.optiFine.getQuadsAndStoreOverlays(quads, this.world, state, worldPos, direction, layer, rand, renderEnv);
            return quads;
        }

        public boolean forEachQuad(List<BakedQuad> quads, BlockState state, BlockPos worldPos, ColorSupplier colorSupplier, RenderType layer, BufferBuilder buffer, Object renderEnv, QuadConsumer action) {
            int i;
            for (i = 0; i < quads.size(); ++i) {
                BakedQuad emissive;
                BakedQuad quad = quads.get(i);
                Color color = colorSupplier.apply(state, worldPos, quad);
                BakedQuad bakedQuad = emissive = this.optiFine == null ? null : this.optiFine.getQuadEmissive(quad);
                if (emissive != null) {
                    this.optiFine.preRenderQuad(renderEnv, emissive, state, worldPos);
                    action.accept(layer, (VertexConsumer)buffer, quad, color, true);
                }
                if (this.optiFine != null) {
                    this.optiFine.preRenderQuad(renderEnv, quad, state, worldPos);
                }
                action.accept(layer, (VertexConsumer)buffer, quad, color, false);
            }
            return i > 0;
        }

        private List<BakedQuad> getMissingQuads() {
            return this.dispatcher.m_110907_().m_110881_().m_119409_().m_213637_(Blocks.f_50016_.m_49966_(), Direction.UP, this.random);
        }

        static interface RenderInLayer {
            public void render(BlockState var1, BlockPos var2, ModelData var3, RenderType var4, BufferBuilder var5, Object var6);
        }

        public static interface ColorSupplier {
            public Color apply(BlockState var1, BlockPos var2, BakedQuad var3);
        }

        public static interface QuadConsumer {
            public void accept(RenderType var1, VertexConsumer var2, BakedQuad var3, Color var4, boolean var5);
        }
    }
}

