/*
 * Decompiled with CFR 0.152.
 */
package io.github.cadiboo.nocubes.client.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.cadiboo.nocubes.NoCubes;
import io.github.cadiboo.nocubes.client.RenderHelper;
import io.github.cadiboo.nocubes.client.RollingProfiler;
import io.github.cadiboo.nocubes.client.render.LightCache;
import io.github.cadiboo.nocubes.client.render.MeshRenderer;
import io.github.cadiboo.nocubes.collision.CollisionHandler;
import io.github.cadiboo.nocubes.config.ColorParser;
import io.github.cadiboo.nocubes.config.NoCubesConfig;
import io.github.cadiboo.nocubes.mesh.Mesher;
import io.github.cadiboo.nocubes.util.Area;
import io.github.cadiboo.nocubes.util.ModUtil;
import io.github.cadiboo.nocubes.util.Vec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public final class OverlayRenderers {
    public static void register(IEventBus events) {
        events.addListener(OverlayRenderers::renderBlockHighlight);
        RollingProfiler meshProfiler = new RollingProfiler(600);
        ArrayList debugOverlays = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"drawOutlineAroundNearbySmoothableBlocks", OverlayRenderers::drawOutlineAroundNearbySmoothableBlocks), Pair.of((Object)"drawOutlineAroundNearbySmoothableBlocks", OverlayRenderers::drawOutlineAroundNearbySmoothableBlocks), Pair.of((Object)"maybeRenderMeshAndRecordPerformance", (camera, matrix, lines) -> OverlayRenderers.maybeRenderMeshAndRecordPerformance(camera, matrix, lines, meshProfiler)), Pair.of((Object)"drawNearbyMeshCollisions", OverlayRenderers::drawNearbyMeshCollisions), Pair.of((Object)"drawNearbyCollisions", OverlayRenderers::drawNearbyCollisions), Pair.of((Object)"drawNearbyDensities", OverlayRenderers::drawNearbyDensities)});
        events.addListener(event -> OverlayRenderers.renderDebugOverlays(event, debugOverlays));
    }

    public static void renderBlockHighlight(RenderHighlightEvent event) {
        if (!NoCubesConfig.Client.render) {
            return;
        }
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        HitResult targetHitResult = event.getTarget();
        if (!(targetHitResult instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult target = (BlockHitResult)targetHitResult;
        BlockPos lookingAtPos = target.m_82425_();
        BlockState state = world.m_8055_(lookingAtPos);
        if (!NoCubes.smoothableHandler.isSmoothable((BlockBehaviour.BlockStateBase)state)) {
            return;
        }
        event.setCanceled(true);
        Vec3 camera = event.getCamera().m_90583_();
        PoseStack matrix = event.getPoseStack();
        VertexConsumer buffer = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        Mesher mesher = NoCubesConfig.Server.mesher;
        boolean stateSolidity = MeshRenderer.isSolidRender(state);
        try (Area area = new Area((BlockGetter)world, lookingAtPos, ModUtil.VEC_ONE, mesher);){
            ColorParser.Color color = NoCubesConfig.Client.selectionBoxColor;
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            mesher.generateGeometry(area, s -> isSmoothable.test((BlockState)s) && MeshRenderer.isSolidRender(s) == stateSolidity, (pos, face) -> {
                RenderHelper.drawFacePosColor(face, camera, area.start, color, buffer, matrix);
                return true;
            });
        }
    }

    public static void renderDebugOverlays(RenderLevelLastEvent event, List<Pair<String, DebugOverlay>> overlays) {
        if (!NoCubesConfig.Client.debugEnabled) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Camera camera = minecraft.f_91063_.m_109153_();
        MultiBufferSource.BufferSource bufferSource = minecraft.m_91269_().m_110104_();
        Supplier<VertexConsumer> linesSupplier = () -> bufferSource.m_6299_(RenderType.m_110504_());
        overlays.forEach(overlay -> {
            ProfilerFiller profiler = minecraft.m_91307_();
            profiler.m_6180_((String)overlay.getLeft());
            try {
                ((DebugOverlay)overlay.getRight()).render(camera, event.getPoseStack(), linesSupplier);
            }
            finally {
                profiler.m_7238_();
            }
        });
        bufferSource.m_109912_(RenderType.m_110504_());
    }

    private static BlockPos getTargetedPosForDebugRendering(Entity viewer) {
        HitResult targeted = viewer.m_19907_(20.0, 0.0f, false);
        return targeted.m_6662_() != HitResult.Type.BLOCK ? viewer.m_20183_() : ((BlockHitResult)targeted).m_82425_();
    }

    private static void drawBlockDestructionProgressForDebug(Minecraft minecraft, Camera camera) {
        Entity viewer = camera.m_90592_();
        BlockPos targetedPos = OverlayRenderers.getTargetedPosForDebugRendering(viewer);
        BlockPos start = targetedPos.m_7918_(-2, -2, -2);
        BlockPos end = targetedPos.m_7918_(2, 2, 2);
        int[] i = new int[]{0};
        BlockPos.m_121940_((BlockPos)start, (BlockPos)end).forEach(pos -> {
            int n = i[0];
            i[0] = n + 1;
            minecraft.f_91060_.m_109774_(100 + n, pos, 9);
        });
    }

    private static void drawOutlineAroundNearbySmoothableBlocks(Camera camera, PoseStack matrix, Supplier<VertexConsumer> buffer) {
        if (!NoCubesConfig.Client.debugOutlineSmoothables) {
            return;
        }
        Entity viewer = camera.m_90592_();
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        ColorParser.Color color = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
        BlockPos start = viewer.m_20183_().m_7918_(-5, -5, -5);
        BlockPos end = viewer.m_20183_().m_7918_(5, 5, 5);
        BlockPos.m_121940_((BlockPos)start, (BlockPos)end).forEach(pos -> {
            if (isSmoothable.test(viewer.f_19853_.m_8055_(pos))) {
                RenderHelper.drawShape(matrix, (VertexConsumer)buffer.get(), Shapes.m_83144_(), pos, camera.m_90583_(), color);
            }
        });
    }

    private static void drawNearbyDensities(Camera camera, PoseStack matrix, Supplier<VertexConsumer> buffer) {
        if (!NoCubesConfig.Client.debugVisualiseDensitiesGrid) {
            return;
        }
        Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
        VoxelShape distanceIndicator = Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)0.125);
        ColorParser.Color densityColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.5f);
        Entity viewer = camera.m_90592_();
        try (Area area = new Area((BlockGetter)viewer.f_19853_, OverlayRenderers.getTargetedPosForDebugRendering(viewer).m_7918_(-2, -2, -2), new BlockPos(4, 4, 4), NoCubesConfig.Server.mesher);){
            BlockState[] states = area.getAndCacheBlocks();
            float[] densities = new float[area.numBlocks()];
            for (int i = 0; i < densities.length; ++i) {
                densities[i] = ModUtil.getBlockDensity(isSmoothable, states[i]);
            }
            int minZ = area.start.m_123343_();
            int minY = area.start.m_123342_();
            int minX = area.start.m_123341_();
            int width = area.size.m_123341_();
            int height = area.size.m_123342_();
            int maxZ = minZ + area.size.m_123343_();
            int maxY = minY + height;
            int maxX = minX + width;
            int zyxIndex = 0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int z = minZ; z < maxZ; ++z) {
                for (int y = minY; y < maxY; ++y) {
                    int x = minX;
                    while (x < maxX) {
                        pos.m_122178_(x, y, z);
                        float density = densities[zyxIndex];
                        float densityScale = 0.5f + density / 2.0f;
                        if ((double)densityScale > 0.01) {
                            VoxelShape box = Shapes.m_83048_((double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 - (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)), (double)(0.5 + (double)(densityScale / 2.0f)));
                            RenderHelper.drawShape(matrix, buffer.get(), box, (BlockPos)pos, camera.m_90583_(), densityColor);
                        }
                        if (x > minX && y > minY && z > minZ) {
                            float combinedDensity = 0.0f;
                            int idx = zyxIndex;
                            int cornerZ = 0;
                            while (cornerZ < 2) {
                                int cornerY = 0;
                                while (cornerY < 2) {
                                    int cornerX = 0;
                                    while (cornerX < 2) {
                                        combinedDensity += densities[idx];
                                        cornerX = (byte)(cornerX + 1);
                                        --idx;
                                    }
                                    ++cornerY;
                                    idx -= width - 2;
                                }
                                ++cornerZ;
                                idx -= width * (height - 2);
                            }
                            float combinedDensityScale = 0.5f + combinedDensity / 16.0f;
                            RenderHelper.drawShape(matrix, buffer.get(), distanceIndicator, (BlockPos)pos, camera.m_90583_(), new ColorParser.Color(combinedDensityScale, 1.0f - combinedDensityScale, 0.0f, 0.4f));
                        }
                        ++x;
                        ++zyxIndex;
                    }
                }
            }
        }
    }

    private static void drawNearbyCollisions(Camera camera, PoseStack matrix, Supplier<VertexConsumer> buffer) {
        if (!NoCubesConfig.Client.debugRenderCollisions) {
            return;
        }
        int collisionsRenderRadius = 10;
        ColorParser.Color intersectingColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
        ColorParser.Color deviatingColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 0.4f);
        Entity viewer = camera.m_90592_();
        VoxelShape viewerShape = Shapes.m_83064_((AABB)viewer.m_20191_());
        viewer.f_19853_.m_186434_(viewer, viewer.m_20191_().m_82400_((double)collisionsRenderRadius)).forEach(voxelShape -> {
            boolean intersects = Shapes.m_83157_((VoxelShape)voxelShape, (VoxelShape)viewerShape, (BooleanOp)BooleanOp.f_82689_);
            RenderHelper.drawShape(matrix, (VertexConsumer)buffer.get(), voxelShape, BlockPos.f_121853_, camera.m_90583_(), intersects ? intersectingColor : deviatingColor);
        });
    }

    private static void drawNearbyMeshCollisions(Camera camera, PoseStack matrix, Supplier<VertexConsumer> buffer) {
        if (!NoCubesConfig.Client.debugRenderMeshCollisions) {
            return;
        }
        int collisionsRenderRadius = 10;
        ColorParser.Color color = new ColorParser.Color(NoCubesConfig.Client.debugRenderCollisions ? 1.0f : 0.0f, 1.0f, 0.0f, 0.4f);
        Entity viewer = camera.m_90592_();
        BlockPos start = viewer.m_20183_().m_7918_(-collisionsRenderRadius, -collisionsRenderRadius, -collisionsRenderRadius);
        CollisionHandler.forEachCollisionShapeRelativeToStart((CollisionGetter)viewer.f_19853_, new BlockPos.MutableBlockPos(), start.m_123341_(), start.m_123341_() + collisionsRenderRadius * 2, start.m_123342_(), start.m_123342_() + collisionsRenderRadius * 2, start.m_123343_(), start.m_123343_() + collisionsRenderRadius * 2, shape -> {
            RenderHelper.drawShape(matrix, (VertexConsumer)buffer.get(), shape, start, camera.m_90583_(), color);
            return true;
        });
    }

    private static void maybeRenderMeshAndRecordPerformance(Camera camera, PoseStack matrix, Supplier<VertexConsumer> linesSupplier, RollingProfiler profiler) {
        if (!NoCubesConfig.Client.debugRecordMeshPerformance && !NoCubesConfig.Client.debugOutlineNearbyMesh) {
            return;
        }
        VertexConsumer buffer = linesSupplier.get();
        long startNanos = System.nanoTime();
        OverlayRenderers.drawNearbyMesh(camera.m_90592_(), camera.m_90583_(), matrix, buffer);
        if (NoCubesConfig.Client.debugRecordMeshPerformance && profiler.recordElapsedNanos(startNanos)) {
            LogManager.getLogger((String)("Calc" + (NoCubesConfig.Client.debugOutlineNearbyMesh ? " & outline" : "") + " nearby mesh")).debug("Average {}ms over the past {} frames", (Object)(profiler.average() / 1000000.0), (Object)profiler.size());
        }
    }

    private static void drawNearbyMesh(Entity viewer, Vec3 camera, PoseStack matrix, VertexConsumer buffer) {
        Mesher mesher = NoCubesConfig.Server.mesher;
        BlockPos meshSize = new BlockPos(16, 16, 16);
        BlockPos meshStart = viewer.m_20183_().m_7918_(-meshSize.m_123341_() / 2, -meshSize.m_123342_() / 2 + 2, -meshSize.m_123343_() / 2);
        try (Area area = new Area((BlockGetter)viewer.f_19853_, meshStart, meshSize, mesher);
             LightCache light = new LightCache((ClientLevel)viewer.f_19853_, meshStart, meshSize);){
            MeshRenderer.FaceInfo faceInfo = new MeshRenderer.FaceInfo();
            MeshRenderer.MutableObjects objects = new MeshRenderer.MutableObjects();
            Vec mutable = new Vec();
            ColorParser.Color faceColor = new ColorParser.Color(0.0f, 1.0f, 1.0f, 0.4f);
            ColorParser.Color normalColor = new ColorParser.Color(0.0f, 0.0f, 1.0f, 0.2f);
            ColorParser.Color averageNormalColor = new ColorParser.Color(1.0f, 0.0f, 0.0f, 0.4f);
            ColorParser.Color normalDirectionColor = new ColorParser.Color(0.0f, 1.0f, 0.0f, 1.0f);
            ColorParser.Color lightColor = new ColorParser.Color(1.0f, 1.0f, 0.0f, 1.0f);
            Predicate<BlockState> isSmoothable = NoCubes.smoothableHandler::isSmoothable;
            mesher.generateGeometry(area, isSmoothable, (pos, face) -> {
                if (!NoCubesConfig.Client.debugOutlineNearbyMesh) {
                    return true;
                }
                RenderHelper.drawFacePosColor(face, camera, area.start, faceColor, buffer, matrix);
                faceInfo.setup(face);
                float dirMul = 0.2f;
                RenderHelper.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.normal).multiply(0.2f), averageNormalColor, buffer, matrix, camera);
                RenderHelper.drawLinePosColorFromAdd(area.start, faceInfo.centre, mutable.set(faceInfo.approximateDirection.m_122429_(), faceInfo.approximateDirection.m_122430_(), faceInfo.approximateDirection.m_122431_()).multiply(0.2f), normalDirectionColor, buffer, matrix, camera);
                RenderHelper.drawLinePosColorFromAdd(area.start, face.v0, mutable.set(faceInfo.vertexNormals.v0).multiply(0.2f), normalColor, buffer, matrix, camera);
                RenderHelper.drawLinePosColorFromAdd(area.start, face.v1, mutable.set(faceInfo.vertexNormals.v1).multiply(0.2f), normalColor, buffer, matrix, camera);
                RenderHelper.drawLinePosColorFromAdd(area.start, face.v2, mutable.set(faceInfo.vertexNormals.v2).multiply(0.2f), normalColor, buffer, matrix, camera);
                RenderHelper.drawLinePosColorFromAdd(area.start, face.v3, mutable.set(faceInfo.vertexNormals.v3).multiply(0.2f), normalColor, buffer, matrix, camera);
                mutable.set(0.5f, 0.5f, 0.5f);
                MeshRenderer.RenderableState.findAt(objects, area, faceInfo.normal, faceInfo.centre, isSmoothable);
                pos.m_122193_((Vec3i)area.start);
                RenderHelper.drawLinePosColorFromTo(area.start, faceInfo.centre, (BlockPos)pos, mutable, lightColor, buffer, matrix, camera);
                return true;
            });
        }
    }

    static interface DebugOverlay {
        public void render(Camera var1, PoseStack var2, Supplier<VertexConsumer> var3);
    }
}

